<?php
    $variables    = get_widget($widget);
    $categories   = $variables['categories'];
?>

<!-- Start Category-Section -->
<?php if($categories->count()): ?>
<div class="row mt-3 mb-3">
    <div class="col-12">
        <div class="category-section dt-sn dt-sl">
            <div class="category-section-title dt-sl">
                <h3><?php echo e(trans('front::messages.index.products-categorization')); ?></h3>
            </div>
            <div class="category-section-slider dt-sl">
                <div class="category-slider owl-carousel">
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="item">
                            <a href="<?php echo e($category->link); ?>" class="promotion-category">
                                <img data-src="<?php echo e($category->image ? asset($category->image) : asset('no-image-product.png')); ?>" alt="<?php echo e($category->title); ?>">
                                <h4 class="promotion-category-name"><?php echo e($category->title); ?></h4>
                                <h6 class="promotion-category-quantity"><?php echo e($category->allPublishedProducts()->count()); ?><?php echo e(trans('front::messages.header.kala')); ?></h6>
                            </a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
<!-- End Category-Section -->
<?php /**PATH /home/akoonli1/public_html/themes/DefaultTheme/src/resources/views/widgets/categories.blade.php ENDPATH**/ ?>