<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">

<head>
    <meta charset="UTF-8">

    <!-- viewport meta -->

    <title>
        <?php if(isset($title)): ?>
            <?php echo e($title); ?> |
        <?php endif; ?>

        <?php echo e(option('info_site_title', 'لاراول شاپ')); ?>

    </title>

    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <?php echo $__env->yieldPushContent('meta'); ?>

    <!-- Favicon Icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(option('info_icon', theme_asset('images/favicon-32x32.png'))); ?>">

    <!-- Font Icon -->
    <link rel="stylesheet" href="<?php echo e(theme_asset('css/vendor/materialdesignicons.min.css')); ?>">

    <?php echo $__env->yieldPushContent('befor-styles'); ?>

    <!-- theme color file -->
    <link rel="stylesheet" href="<?php echo e(theme_asset('css/colors/' . option('dt_theme_color', 'default') . '.css')); ?>?v=<?php echo e(time()); ?>">

    <?php if($current_local['direction'] == 'ltr'): ?>
        <link rel="stylesheet" href="<?php echo e(theme_asset('css/vendor/bootstrap.ltr.min.css')); ?>">
    <?php else: ?>
        <link rel="stylesheet" href="<?php echo e(theme_asset('css/vendor/bootstrap.min.css')); ?>">
    <?php endif; ?>

    <?php if(config('app.debug')): ?>
        <!-- inject:css -->
        <link rel="stylesheet" href="<?php echo e(theme_asset('css/vendor/bootstrap-rtl.min.css')); ?>">
        <!-- Plugins -->
        <link rel="stylesheet" href="<?php echo e(theme_asset('css/vendor/owl.carousel.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(theme_asset('css/vendor/jquery.horizontalmenu.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(theme_asset('js/plugins/toastr/toastr.css')); ?>">

        <!-- Main CSS File -->
        <link rel="stylesheet" href="<?php echo e(theme_asset('css/main.css')); ?>?v=23">
        <link rel="stylesheet" href="<?php echo e(theme_asset('css/styles.css')); ?>?v=32">
        <link rel="stylesheet" href="<?php echo e(theme_asset('css/custom.css')); ?>?v=2">
        <!-- endinject -->

    <?php else: ?>
        <!-- All Css Files -->
        <link rel="stylesheet" href="<?php echo e(mix('css/all.css', config('front.mainfest_path'))); ?>">
    <?php endif; ?>

    <?php if($current_local['direction'] == 'ltr'): ?>
        <link rel="stylesheet" href="<?php echo e(theme_asset('css/ltr.css')); ?>?v=2">
    <?php endif; ?>

    <?php echo $__env->yieldPushContent('styles'); ?>

    <?php echo option('info_header_codes'); ?>

</head>

<body>
    <div class="wrapper <?php echo $__env->yieldContent('wrapper-classes'); ?>">


        <!-- Start header -->
        <header class="main-header dt-sl">

            <!-- Start topbar -->
            <div class="container main-container">
                <div class="topbar dt-sl">
                    <div class="row align-items-center">
                        <div class="col-lg-2 col-md-3 col-4">
                            <div class="logo-area float-right">
                                <a href="<?php echo e(route('front.index')); ?>">
                                    <img data-src="<?php echo e(option('info_logo', theme_asset('img/logo.png'))); ?>" alt="<?php echo e(option('info_site_title', 'لاراول شاپ')); ?>">
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-5 hidden-sm">
                            <div class="search-area dt-sl">
                                <form id="search-form" action="<?php echo e(route('front.products.search')); ?>" class="search">
                                    <input type="text" name="q" value="<?php echo e(request('q')); ?>" id="search-input" autocomplete="off" placeholder="<?php echo e(trans('front::messages.header.Search-for-product')); ?>">
                                    <button type="submit"><img data-src="<?php echo e(theme_asset('img/theme/search.png')); ?>" alt="search button"></button>
                                    <button id="close-search-result" class="close-search-result" type="button"><i class="mdi mdi-close"></i></button>
                                    <div class="search-result p-0" id="search-result">
                                        <ul>

                                        </ul>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="col-md-4 col-8 topbar-left">
                            <?php echo $__env->make('front::partials.user-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End topbar -->

            <!-- Start bottom-header -->
            <div class="bottom-header dt-sl mb-sm-bottom-header">
                <div class="container main-container">
                    <!-- Start Main-Menu -->
                    <?php echo $__env->make('front::partials.menu.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!-- End Main-Menu -->
                </div>
            </div>
            <!-- End bottom-header -->
        </header>
        <!-- End header -->


        <?php echo $__env->yieldContent('content'); ?>

        <?php echo $__env->make('front::partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <script>
        var BASE_URL = "<?php echo e(route('front.index')); ?>";
        var IS_RTL = <?php echo e($current_local['direction'] == 'rtl' ? 1 : 0); ?>;
    </script>

    <?php if(config('app.debug')): ?>
        <!-- Core JS Files -->
        <script src="<?php echo e(theme_asset('js/vendor/jquery-3.4.1.min.js')); ?>"></script>
        <script src="<?php echo e(theme_asset('js/vendor/popper.min.js')); ?>"></script>
        <script src="<?php echo e(theme_asset('js/vendor/bootstrap.min.js')); ?>"></script>
        <!-- Plugins -->
        <script src="<?php echo e(theme_asset('js/vendor/owl.carousel.min.js')); ?>"></script>
        <script src="<?php echo e(theme_asset('js/vendor/jquery.horizontalmenu.js')); ?>"></script>
        <script src="<?php echo e(theme_asset('js/vendor/theia-sticky-sidebar.min.js')); ?>"></script>
        <script src="<?php echo e(theme_asset('js/vendor/jquery.lazyloadxt.min.js')); ?>"></script>

        <script src="<?php echo e(theme_asset("js/plugins/jquery.blockUI.js")); ?>"></script>
        <script src="<?php echo e(theme_asset("js/plugins/sweetalert2.all.min.js")); ?>"></script>
        <script src="<?php echo e(theme_asset("js/plugins/toastr/toastr.min.js")); ?>"></script>

        <!-- Main JS File -->
        <script src="<?php echo e(theme_asset('js/main.js')); ?>?v=5"></script>
        <script src="<?php echo e(theme_asset('js/custom.js')); ?>"></script>
        <script src="<?php echo e(theme_asset("js/scripts.js")); ?>?v=15"></script>
    <?php else: ?>
        <!-- All JS Files -->
        <script src="<?php echo e(mix('js/all.js', config('front.mainfest_path'))); ?>"></script>
    <?php endif; ?>

    <?php echo $__env->yieldPushContent('scripts'); ?>

    <?php if($current_local['direction'] == 'ltr'): ?>
        <script src="<?php echo e(theme_asset('js/ltr.js')); ?>"></script>
    <?php endif; ?>



    <?php echo option('info_scripts'); ?>

    <!-- endinject -->
</body>

</html>
<?php /**PATH /home/akoonli1/public_html/themes/DefaultTheme/src/resources/views/layouts/master.blade.php ENDPATH**/ ?>