<?php
    $variables      = get_widget($widget);
    $posts          = $variables['posts'];
?>

<!-- Start posts -->
<?php if($posts->count()): ?>
    <div class="row">
        <div class="col-xl-12 col-lg-12">
            <section class="slider-section dt-sl mb-3">
                <div class="row mb-3">
                    <div class="col-12">
                        <div class="section-title text-sm-title title-wide no-after-title-wide">
                            <h2><?php echo e($widget->option('title')); ?></h2>
                            <?php if($widget->option('link')): ?>
                                <a href="<?php echo e($widget->option('link')); ?>"><?php echo e($widget->option('link_title', trans('front::messages.user.see-all') )); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="col-12 px-res-0">
                        <div class="product-carousel carousel-md owl-carousel owl-theme posts-widget-owl">
                            <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="item">
                                    <div class="post-card mb-0">
                                        <div class="post-thumbnail">
                                            <a href="<?php echo e(route('front.posts.show', ['post' => $post])); ?>">
                                                <img src="<?php echo e(theme_asset('images/blog-empty-image.jpg')); ?>" data-src="<?php echo e($post->image ? asset($post->image) : theme_asset('images/blog-empty-image.jpg')); ?>" alt="<?php echo e($post->title); ?>">
                                            </a>
                                            <span class="post-tag"><?php echo e($post->category ? $post->category->title : trans('front::messages.user.uncategorized')); ?></span>

                                        </div>
                                        <div class="post-title">
                                            <a href="<?php echo e(route('front.posts.show', ['post' => $post])); ?>"><?php echo e($post->title); ?></a>
                                            <span class="post-date"><?php echo e(jdate($post->created_at)->format('%d %B %Y')); ?></span>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
<?php endif; ?>
<!-- End posts -->
<?php /**PATH /home/akoonli1/public_html/themes/DefaultTheme/src/resources/views/widgets/posts.blade.php ENDPATH**/ ?>