
<?php if(auth()->guard()->check()): ?>
    <div class="section-title title-wide no-after-title-wide dt-sl">
        <h2><?php echo e(trans('front::messages.posts.post-a-comment')); ?></h2>
    </div>
    <div class="form-question-answer dt-sl mb-3 comment--form">
        <div class="comment-replay-to" style="display: none">
            <span></span> <a href="javasript:void(0)"> <?php echo e(trans('front::messages.posts.cancel-reply')); ?></a>
        </div>
        <!-- start form -->
        <form id="comments-form" class="cmnt_reply_form" action="<?php echo e($route_link); ?>" method="post">
            <input type="hidden" name="comment_id">
            <textarea class="form-control mb-3" rows="5" name="body" required></textarea>
            <button type="submit" class="btn btn-dark float-right ml-3 comment-submit-btn"><?php echo e(trans('front::messages.posts.submit-a-comment')); ?></button>
        </form>
    </div>
<?php else: ?>
    <div class="section-title title-wide no-after-title-wide dt-sl">
        <h2><?php echo e(trans('front::messages.posts.post-a-comment')); ?></h2>
        <div class="alert alert-warning" role="alert">
            <?php echo e(trans('front::messages.posts.logged-a-comment')); ?>

        </div>
    </div>

<?php endif; ?>

<div class="comments-area default">

    <?php if($model->comments->count()): ?>
        <div class="section-title text-sm-title title-wide no-after-title-wide mt-2 mb-0 dt-sl">
            <p class="count-comment"><?php echo e($model->comments()->where('status', 'accepted')->count()); ?> <?php echo e(trans('front::messages.posts.comments')); ?></p>
        </div>
        <ol class="comment-list">
            <?php $__currentLoopData = $model->comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <li>
                    <div class="comment-body">
                        <div class="comment-author">
                            <span class="icon-comment">?</span>
                            <cite class="fn"><?php echo e($comment->user->fullname); ?></cite>
                            <span class="says"><?php echo e(trans('front::messages.posts.said')); ?></span>
                            <div class="commentmetadata">
                                <?php echo e(jdate($comment->created_at)->format('%d %B %Y')); ?>

                            </div>
                        </div>
                        <p><?php echo nl2br(htmlentities($comment->body)); ?></p>

                        <?php if(auth()->guard()->check()): ?>
                            <div class="reply"><a class="comment-reply-link comment-replay" data-name="<?php echo e($comment->user->fullname); ?>" data-id="<?php echo e($comment->id); ?>" href="#">پاسخ</a></div>
                        <?php endif; ?>
                    </div>

                    <?php
                        $child_comments = $comment->comments()->where('status', 'accepted')->get()
                    ?>

                    <?php if($child_comments->count()): ?>
                        <ol class="children">
                            <?php $__currentLoopData = $child_comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child_comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <div class="comment-body">
                                        <div class="comment-author">
                                                <span
                                                        class="icon-comment mdi mdi-lightbulb-on-outline"></span>
                                            <cite class="fn"><?php echo e($child_comment->user->fullname); ?></cite> <span
                                                    class="says"><?php echo e(trans('front::messages.posts.said')); ?></span>
                                            <div class="commentmetadata">
                                                <?php echo e(jdate($comment->created_at)->format('%d %B %Y')); ?>

                                            </div>
                                        </div>
                                        <p><?php echo nl2br(htmlentities($child_comment->body)); ?></p>

                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </ol>
                    <?php endif; ?>

                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </ol>
    <?php else: ?>
        <ol class="comment-list">
            <?php if(isset($message)): ?>
                <p class="p-2"><?php echo e($message); ?></p>
            <?php else: ?>
                <p class="p-2"> <?php echo e(trans('front::messages.posts.there-article')); ?></p>
            <?php endif; ?>
        </ol>
    <?php endif; ?>

</div>
<?php /**PATH /home/akoonli1/public_html/themes/DefaultTheme/src/resources/views/components/comments.blade.php ENDPATH**/ ?>