<form id="filter-products-form" method="GET" action="<?php echo e($filter_action); ?>">
    <div class="card mb-1">
        <div class="card-header filter-card">
            <h4 class="card-title">فیلتر کردن</h4>
            <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
            <div class="heading-elements">
                <ul class="list-inline mb-0">
                    <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                </ul>
            </div>
        </div>
        <div class="card-content collapse <?php echo e(request()->except('page') ? 'show' : ''); ?>">
            <div class="card-body">
                <div class="users-list-filter">

                    <div class="row">
                        <div class="col-md-4">
                            <label>عنوان</label>
                            <fieldset class="form-group">
                                <input class="form-control datatable-filter" name="title" value="<?php echo e(request('title')); ?>">
                            </fieldset>
                        </div>
                        <div class="col-md-2">
                            <label>برند</label>
                            <fieldset class="form-group">
                                <select class="form-control datatable-filter select2" name="brand_id">
                                    <option value="all" <?php echo e(request('brand_id') == 'all' ? 'selected' : ''); ?>>
                                        همه
                                    </option>
                                    <option value="none" <?php echo e(request('brand_id') == 'none' ? 'selected' : ''); ?>>
                                        انتخاب نشده
                                    </option>

                                    <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($brand->id); ?>" <?php echo e(request('brand_id') == $brand->id ? 'selected' : ''); ?>>
                                            <?php echo e($brand->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </fieldset>
                        </div>

                        <div class="col-md-2">
                            <label>نوع مشخصات</label>
                            <fieldset class="form-group">
                                <select class="form-control datatable-filter select2" name="spec_type_id">
                                    <option value="all" <?php echo e(request('spec_type_id') == 'all' ? 'selected' : ''); ?>>
                                        همه
                                    </option>
                                    <option value="none" <?php echo e(request('spec_type_id') == 'none' ? 'selected' : ''); ?>>
                                        انتخاب نشده
                                    </option>

                                    <?php $__currentLoopData = $specTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($specType->id); ?>" <?php echo e(request('spec_type_id') == $specType->id ? 'selected' : ''); ?>>
                                            <?php echo e($specType->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </fieldset>
                        </div>

                        <div class="col-md-2">
                            <label>وضعیت موجودی</label>
                            <fieldset class="form-group">
                                <select class="form-control datatable-filter" name="stock">
                                    <option value="all" <?php echo e(request('stock') == 'all' ? 'selected' : ''); ?>>
                                        همه
                                    </option>
                                    <option value="available" <?php echo e(request('stock') == 'available' ? 'selected' : ''); ?>>
                                        موجود
                                    </option>
                                    <option value="unavailable" <?php echo e(request('stock') == 'unavailable' ? 'selected' : ''); ?>>
                                        ناموجود
                                    </option>
                                </select>
                            </fieldset>
                        </div>
                        <div class="col-md-2">
                            <label>وضعیت تخفیف</label>
                            <fieldset class="form-group">
                                <select class="form-control datatable-filter" name="discount">
                                    <option value="all" <?php echo e(request('discount') == 'all' ? 'selected' : ''); ?>>
                                        همه
                                    </option>
                                    <option value="yes" <?php echo e(request('discount') == 'yes' ? 'selected' : ''); ?>>
                                        تخفیف دار
                                    </option>
                                    <option value="no" <?php echo e(request('discount') == 'no' ? 'selected' : ''); ?>>
                                        بدون تخفیف
                                    </option>
                                </select>
                            </fieldset>
                        </div>

                        <div class="col-md-2">
                            <label>وضعیت انتشار</label>
                            <fieldset class="form-group">
                                <select class="form-control datatable-filter" name="published">
                                    <option value="all" <?php echo e(request('published') == 'all' ? 'selected' : ''); ?>>
                                        همه
                                    </option>
                                    <option value="yes" <?php echo e(request('published') == 'yes' ? 'selected' : ''); ?>>
                                        منتشر شده
                                    </option>
                                    <option value="no" <?php echo e(request('published') == 'no' ? 'selected' : ''); ?>>
                                        پیش نویس
                                    </option>
                                </select>
                            </fieldset>
                        </div>
                        <div class="col-md-2">
                            <label>محصول ویژه</label>
                            <fieldset class="form-group">
                                <select class="form-control datatable-filter" name="special">
                                    <option value="all" <?php echo e(request('special') == 'all' ? 'selected' : ''); ?>>
                                        همه
                                    </option>
                                    <option value="yes" <?php echo e(request('special') == 'yes' ? 'selected' : ''); ?>>
                                        بله
                                    </option>
                                    <option value="no" <?php echo e(request('special') == 'no' ? 'selected' : ''); ?>>
                                        خیر
                                    </option>
                                </select>
                            </fieldset>
                        </div>
                        <div class="col-md-2">
                            <label>لینک ترب</label>
                            <fieldset class="form-group">
                                <select class="form-control datatable-filter" name="torob_link">
                                    <option value="all" <?php echo e(request('torob_link') == 'all' ? 'selected' : ''); ?>>
                                        همه
                                    </option>
                                    <option value="yes" <?php echo e(request('torob_link') == 'yes' ? 'selected' : ''); ?>>
                                        موجود باشد
                                    </option>
                                    <option value="no" <?php echo e(request('torob_link') == 'no' ? 'selected' : ''); ?>>
                                        موجود نباشد
                                    </option>
                                </select>
                            </fieldset>
                        </div>
                        <div class="col-md-3 d-none">
                            <label>نوع محصول</label>
                            <fieldset class="form-group">
                                <select class="form-control datatable-filter" name="type">
                                    <option value="all" <?php echo e(request('type') == 'all' ? 'selected' : ''); ?>>
                                        همه
                                    </option>
                                    <option value="physical" <?php echo e(request('type') == 'physical' ? 'selected' : ''); ?>>
                                        فیزیکی
                                    </option>
                                    <option value="download" <?php echo e(request('type') == 'download' ? 'selected' : ''); ?>>
                                        دانلودی
                                    </option>
                                </select>
                            </fieldset>
                        </div>
                        <div class="col-md-2">
                            <label>آیدی محصول</label>
                            <fieldset class="form-group">
                                <input name="id" type="text" class="form-control datatable-filter" value="<?php echo e(request()->id); ?>">
                            </fieldset>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>دسته بندی ها</label>
                                <select class="form-control datatable-filter product-category" name="category_id[]" multiple>
                                    <option class="l1 " data-pup="" <?php echo e(request()->input('category_id') && in_array('no_category', request()->input('category_id')) ? 'selected' : ''); ?> value="no_category">بدون دسته بندی</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option class="l<?php echo e($category->parents()->count() + 1); ?> <?php echo e($category->categories()->count() ? 'non-leaf' : ''); ?>" data-pup="<?php echo e($category->category_id); ?>" <?php echo e(request()->input('category_id') && in_array($category->id, request()->input('category_id')) ? 'selected' : ''); ?> value="<?php echo e($category->id); ?>"><?php echo e($category->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label>توضیحات</label>
                            <fieldset class="form-group">
                                <input class="form-control datatable-filter" name="description" value="<?php echo e(request('description')); ?>">
                            </fieldset>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

</form>
<?php /**PATH /home/akoonli1/public_html/resources/views/back/products/partials/index-filters.blade.php ENDPATH**/ ?>