<div class="ah-tab-content comments-tab dt-sl">

    <div class="dt-sl">
        <div class="row">
            <div class="col-md-6 col-sm-12">
                <div class="comments-summary-note">
                    <span><?php echo e(trans('front::messages.reviews.you-can-also-comment')); ?></span>
                    <p><?php echo e(trans('front::messages.reviews.login-to-submit-comment')); ?></p>
                    <div class="dt-sl mt-2 mb-4">
                        <?php if(auth()->check()): ?>
                            <button data-toggle="modal" data-target="#add-product-review-modal" class="btn-primary-cm btn-with-icon">
                                <i class="mdi mdi-comment-text-outline"></i>
                                <?php echo e(trans('front::messages.reviews.add-review')); ?>

                            </button>
                        <?php else: ?>
                            <a href="<?php echo e(route('login', ['redirect', route('front.products.show', ['product' => $product])])); ?>" class="btn-primary-cm btn-with-icon">
                                <i class="mdi mdi-comment-text-outline"></i>
                                <?php echo e(trans('front::messages.reviews.add-review')); ?>

                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <?php if($reviews->count()): ?>
            <div class="comments-area dt-sl">
                <div class="section-title text-sm-title title-wide no-after-title-wide mb-0 dt-sl">
                    <h2><?php echo e(trans('front::messages.reviews.user-comments')); ?></h2>
                    <p class="count-comment"><span class="rate-product"><?php echo e(trans('front::messages.reviews.reviews-count', ['rating' => $product->rating, 'review_count' => $product->reviews_count])); ?></span></p>
                </div>
                <ol class="comment-list">
                    <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <!-- #comment-## -->
                        <li>
                            <div class="comment-body">
                                <div class="row">

                                    <div class="col-md-12 col-sm-12 comment-content">
                                        <div class="comment-title">
                                            <?php echo e($review->title); ?>

                                        </div>
                                        <div class="comment-author">
                                            توسط <?php echo e($review->user->fullname); ?> در تاریخ <?php echo e(jdate($review->created_at)->format('%d %B %Y')); ?>

                                            <?php if($review->suggest): ?>
                                                <span class="badge badge-success">خریدار</span>
                                            <?php endif; ?>
                                        </div>


                                        <p><?php echo nl2br(htmlentities($review->body)); ?></p>

                                        <?php if($review->points->count()): ?>
                                            <div class="row">
                                                <?php if($review->points->where('type', 'positive')->count()): ?>
                                                    <div class="col-md-4 col-sm-6 col-12">
                                                        <div class="content-expert-evaluation-positive">
                                                            <span>نقاط قوت</span>
                                                            <ul>
                                                                <?php $__currentLoopData = $review->points->where('type', 'positive'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <li><?php echo e($point->text); ?></li>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>

                                                <?php if($review->points->where('type', 'negative')->count()): ?>
                                                    <div class="col-md-4 col-sm-6 col-12">
                                                        <div class="content-expert-evaluation-negative">
                                                            <span>نقاط ضعف</span>
                                                            <ul>
                                                                <?php $__currentLoopData = $review->points->where('type', 'negative'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <li><?php echo e($point->text); ?></li>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>

                                        <?php switch($review->suggest):
                                            case ('yes'): ?>
                                                <div class="user-suggest text-success"><i class="mdi mdi-thumb-up-outline"></i> پیشنهاد می کنم</div>
                                                <?php break; ?>
                                            <?php case ('not_sure'): ?>
                                                <div class="user-suggest text-muted"><i class="mdi mdi-help"></i> مطمئن نیستم</div>
                                                <?php break; ?>
                                            <?php case ('no'): ?>
                                                <div class="user-suggest text-danger"><i class="mdi mdi-thumb-down-outline"></i> پیشنهاد نمی کنم</div>
                                                <?php break; ?>

                                        <?php endswitch; ?>

                                        <div class="footer">
                                            <div class="comments-likes">
                                                <button data-action="<?php echo e(route('front.reviews.like', ['review' => $review])); ?>" class="btn-like">
                                                    <span class="likes-count"><?php echo e($review->likes_count); ?></span> <i class="mdi mdi-thumb-up-outline"></i>
                                                </button>
                                                <button data-action="<?php echo e(route('front.reviews.dislike', ['review' => $review])); ?>" class="btn-like">
                                                    <span class="dislikes-count"><?php echo e($review->dislikes_count); ?></span> <i class="mdi mdi-thumb-down-outline"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ol>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/akoonli1/public_html/themes/DefaultTheme/src/resources/views/products/partials/reviews.blade.php ENDPATH**/ ?>