<?php $__env->startPush('meta'); ?>
    <?php if(option('allow_indexing_product_page') == "off"): ?>
    <meta name="robots" content="noindex, nofollow">
    <meta name="googlebot" content="noindex, nofollow">
    <meta name="bingbot" content="noindex, nofollow">

    <?php else: ?>
    <meta name="robots" content="index, follow"/>
    <meta name="googlebot" content="index, follow">
    <meta name="bingbot" content="index, follow">
    <?php endif; ?>
    <meta name="description" content="<?php echo e(option('info_short_description')); ?>">
    <meta name="keywords" content="<?php echo e(option('info_tags')); ?>">
    <link rel="canonical" href="<?php echo e(route('front.products.index')); ?>" />
    <?php echo $__env->make('front::products.partials.product-meta', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(theme_asset('css/vendor/fancybox.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <!-- Start main-content -->
    <main class="main-content dt-sl mt-4 mb-3">
        <div class="container main-container">
            <!-- Start title - breadcrumb -->
            <div class="title-breadcrumb-special dt-sl mb-3">
                <div class="breadcrumb dt-sl">
                    <nav>
                        <a href="<?php echo e(route('front.index')); ?>"><?php echo e(trans('front::messages.products.home')); ?></a>
                        <a href="<?php echo e(route('front.products.index')); ?>"><?php echo e(trans('front::messages.products.products')); ?></a>
                        <?php if($product->category): ?>

                            <?php $__currentLoopData = $product->category->parents(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(route('front.products.category', ['category' => $parent])); ?>"><?php echo e($parent->title); ?></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <a href="<?php echo e(route('front.products.category', ['category' => $product->category])); ?>"><?php echo e($product->category->title); ?></a>

                        <?php endif; ?>
                        <span><?php echo e($product->title); ?></span>
                    </nav>
                </div>
            </div>
            <!-- End title - breadcrumb -->

            <!-- Start Product -->
            <div class="dt-sn mb-3 dt-sl">
                <div class="row">
                    <!-- Product Gallery-->
                    <div class="col-lg-4 col-md-12 ps-relative">
                        <?php if(!$product->addableToCart()): ?>
                            <div class="product-timeout position-relative pt-5 mb-4">
                                <div class="promotion-badge not-available">
                                    <?php echo e(trans('front::messages.products.unavailable')); ?>

                                </div>
                            </div>
                        <?php elseif($product->isSpecial()): ?>

                            <div class="product-timeout position-relative pt-5 mb-4">
                                <div class="promotion-badge">
                                    <div class="product-special">
                                        <?php echo e(trans('front::messages.products.special-sale')); ?>

                                    </div>
                                </div>
                                <?php if($product->special_end_date): ?>
                                    <div id="product-special-end-date" class="countdown-timer mt-4" countdown data-date="<?php echo e($product->special_end_date->format('D M d Y H:i:s O')); ?>">
                                        <span data-days="">0</span>:
                                        <span data-hours="">0</span>:
                                        <span data-minutes="">0</span>:
                                        <span data-seconds="">0</span>
                                    </div>
                                <?php endif; ?>
                            </div>

                        <?php endif; ?>

                        <ul class="gallery-options <?php echo e($product->isSpecial() ? 'special' : ''); ?>">
                            <?php if(auth()->check()): ?>
                                <?php
                                    $favorite_product = auth()->user()->favorites()->where('product_id', $product->id)->first();
                                ?>
                                <li>
                                    <button id="add-to-favorites" data-action="<?php echo e(route('front.favorites.store')); ?>" data-product="<?php echo e($product->id); ?>" class="add-favorites <?php echo e($favorite_product ? 'favorites' : ''); ?>"><i class="mdi mdi-heart"></i></button>
                                    <?php if($favorite_product): ?>
                                        <span class="tooltip-option">  <?php echo e(trans('front::messages.products.remove-from-favorites')); ?> </span>
                                    <?php else: ?>
                                        <span class="tooltip-option"><?php echo e(trans('front::messages.products.add-to-favorites')); ?></span>
                                    <?php endif; ?>
                                </li>
                            <?php endif; ?>

                            <?php if($similar_products_count): ?>
                                <a href="<?php echo e(route('front.products.compare', ['product1' => $product->id])); ?>">
                                    <li>
                                        <button class="add-favorites"><i class="mdi mdi-compare"></i></button>
                                        <span class="tooltip-option"><?php echo e(trans('front::messages.products.comparison')); ?></span>
                                    </li>
                                </a>
                            <?php endif; ?>

                            <?php if($show_prices_chart): ?>
                                <li>
                                    <button data-toggle="modal" data-target="#price-changes-modal"><i class="mdi mdi-chart-line"></i></button>
                                    <span class="tooltip-option"><?php echo e(trans('front::messages.products.price-chart')); ?></span>
                                </li>
                            <?php endif; ?>

                            <?php if(option('show_product_share_links', 1) == 1): ?>
                                <li>
                                    <button data-toggle="modal" data-target="#shareproduct"><i class="mdi mdi-share-variant"></i></button>
                                    <span class="tooltip-option">اشتراک گذاری</span>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.update')): ?>
                                <li>
                                    <a href="<?php echo e(route('admin.products.edit', ['product' => $product])); ?>" target="_blank">
                                        <button><i class="mdi mdi-pencil text-warning"></i></button>
                                    </a>
                                    <span class="tooltip-option"><?php echo e(trans('front::messages.products.edit')); ?></span>
                                </li>
                            <?php endif; ?>

                        </ul>

                        <?php if($product->gallery()->count()): ?>
                            <div id="product-gallery" class="product-gallery mt-3">
                                <div class="product-carousel main-gallery owl-carousel">
                                    <?php $__currentLoopData = $product->gallery()->orderBy('ordering')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="item gallery-image-item" data-color-id="<?php echo e($item->color_id); ?>">
                                            <a class="gallery-item mt-3" href="<?php echo e(asset($item->image)); ?>" data-fancybox="gallery" data-owl="one<?php echo e($loop->index); ?>">
                                                <img src="<?php echo e(theme_asset('images/600-600.png')); ?>" data-src="<?php echo e(asset($item->image)); ?>" alt="<?php echo e($product->title); ?>">
                                            </a>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <hr class="border-product"/>
                                <ul class="product-thumbnails product-carousel owl-carousel carousel-products">
                                    <?php $__currentLoopData = $product->gallery()->orderBy('ordering')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="<?php echo e(($loop->index == 0) ? 'active' : ''); ?> gallery-image-item" data-color-id="<?php echo e($item->color_id); ?>" data-image="<?php echo e(asset($item->image)); ?>">
                                            <a href="#one<?php echo e($loop->index); ?>" class="owl-thumbnail" data-slide="<?php echo e($loop->index); ?>">
                                                <img src="<?php echo e(theme_asset('images/600-600.png')); ?>" data-src="<?php echo e(asset($item->image)); ?>" alt="<?php echo e($product->title); ?>">
                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                    </div>
                    <?php echo $__env->make('front::products.partials.product-info', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
            <div class="dt-sn mb-3 px-0 dt-sl pt-0">
                <!-- Start tabs -->
                <section class="tabs-product-info mb-3 dt-sl">
                    <div class="ah-tab-wrapper dt-sl">
                        <div class="ah-tab dt-sl">
                            <?php if($product->isDownload()): ?>
                                <a class="ah-tab-item" href="javascript:void(0)"><i class="mdi mdi-download"></i><?php echo e(trans('front::messages.products.product-files')); ?></a>
                            <?php endif; ?>

                            <?php if($product->description): ?>
                                <a class="ah-tab-item" href="javascript:void(0)"><i class="mdi mdi-glasses"></i><?php echo e(trans('front::messages.products.general-specifications')); ?></a>
                            <?php endif; ?>

                            <?php if($product->specificationGroups()->count()): ?>
                                <a class="ah-tab-item" href="javascript:void(0)"><i class="mdi mdi-format-list-checks"></i><?php echo e(trans('front::messages.products.technical-specifications')); ?></a>
                            <?php endif; ?>

                            <a class="ah-tab-item" href="javascript:void(0)"><i class="mdi mdi-comment-text-multiple-outline"></i><?php echo e(trans('front::messages.products.comment')); ?></a>

                            <a class="ah-tab-item" href="javascript:void(0)"><i class="mdi mdi-comment-question-outline"></i><?php echo e(trans('front::messages.products.comments-questions-answers')); ?></a>
                        </div>
                    </div>
                    <div class="ah-tab-content-wrapper product-info px-4 dt-sl">
                        <?php if($product->isDownload()): ?>
                            <?php echo $__env->make('front::products.partials.links-tab', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>

                        <?php if($product->description): ?>
                            <div class="ah-tab-content dt-sl">
                                <div class="section-title text-sm-title title-wide no-after-title-wide mb-0 dt-sl">
                                    <h2><?php echo e(trans('front::messages.products.general-specifications')); ?></h2>
                                </div>

                                <div class="description-product dt-sl mt-3 mb-3">
                                    <div class="container">
                                        <p><?php echo $product->description; ?></p>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if($product->specificationGroups()->count()): ?>
                            <div class="ah-tab-content params dt-sl">
                                <div class="section-title text-sm-title title-wide no-after-title-wide mb-0 dt-sl">
                                    <h2><?php echo e(trans('front::messages.products.technical-specifications')); ?></h2>
                                </div>
                                <?php $__currentLoopData = $product->specificationGroups->unique(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <section>
                                        <h3 class="params-title"><?php echo e($group->name); ?></h3>
                                        <ul class="params-list">
                                            <?php $__currentLoopData = $product->specifications()->where('specification_group_id', $group->id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li>
                                                    <div class="params-list-key">
                                                        <span class="d-block"><?php echo e($specification->name); ?></span>
                                                    </div>
                                                    <div class="params-list-value">
                                                            <span class="d-block">
                                                                <?php echo nl2br(htmlentities($specification->pivot->value)); ?>

                                                            </span>
                                                    </div>

                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </section>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>

                        <?php echo $__env->make('front::products.partials.reviews', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <div class="ah-tab-content dt-sl">
                            <?php echo $__env->make('front::components.comments', ['model' => $product, 'route_link' => route('front.product.comments', ['product' => $product]), 'message' => trans('front::messages.products.no-comments') ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </section>
                <!-- End tabs -->
            </div>
            <!-- End Product -->

            <?php if($related_products->count()): ?>
                <!-- Start Product-Slider -->
                <section class="slider-section dt-sl">
                    <div class="row mb-3">
                        <div class="col-12">
                            <div class="section-title text-sm-title title-wide no-after-title-wide">
                                <h2><?php echo e(trans('front::messages.products.related-products')); ?></h2>
                            </div>
                        </div>

                        <!-- Start Product-Slider -->
                        <div class="col-12">
                            <div class="product-carousel carousel-lg owl-carousel owl-theme">
                                <?php $__currentLoopData = $related_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $related_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo $__env->make('front::partials.product-block', ['product' => $related_product], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                        </div>
                        <!-- End Product-Slider -->

                    </div>
                </section>
                <!-- End Product-Slider -->
            <?php endif; ?>

        </div>
    </main>
    <!-- End main-content -->


    <?php if(!$product->addableToCart()): ?>
        <!-- Start Modal stocknotify -->
        <div class="modal fade" id="modal-stock-notify" role="dialog"
            aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
            <div class="modal-dialog modal-md send-info modal-dialog-centered"
                role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalCenterTitle">
                            <i class="now-ui-icons location_pin"></i>
                            <?php echo e(trans('front::messages.products.inventory-information')); ?>

                        </h5>
                        <button type="button" class="close" data-dismiss="modal"
                            aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-ui dt-sl">
                                    <form class="form-account" action="#">
                                        <div class="row">
                                            <div class="col-md-6 col-sm-12 mb-2">
                                                <div class="form-row-title">
                                                    <h4>
                                                        <?php echo e(trans('front::messages.products.fname-and-lname')); ?> </h4>
                                                </div>
                                                <div class="form-row">
                                                    <input class="input-ui pr-2 text-right"
                                                        type="text"
                                                        name="name"
                                                        id="stock-name"
                                                        placeholder=" <?php echo e(trans('front::messages.products.enter-your-name')); ?> " required>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-sm-12 mb-2">
                                                <div class="form-row-title">
                                                    <h4>
                                                        <?php echo e(trans('front::messages.products.phone-number')); ?>

                                                    </h4>
                                                </div>
                                                <div class="form-row">
                                                    <input
                                                        class="input-ui pl-2 dir-ltr text-left"
                                                        type="text"
                                                        name="mobile"
                                                        id="stock-mobile"
                                                        placeholder="09xxxxxxxxx" required>
                                                </div>
                                            </div>

                                            <div class="col-12 pr-4 pl-4 text-center">
                                                <button id="sendStockNotifyBtn" type="button" class="btn btn-md btn-primary btn-submit-form" data-dismiss="modal"><?php echo e(trans('front::messages.products.let-me-know')); ?></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Modal stocknotify -->
    <?php endif; ?>

    <?php if($show_prices_chart): ?>
        <!-- Modal -->
        <div class="modal fade" id="price-changes-modal" tabindex="-1" aria-labelledby="price-changes-modal-label" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header pb-0">
                        <h5 class="modal-title" id="price-changes-modal-label"><?php echo e(trans('front::messages.products.sales-price-chart')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body chart-area">
                        <strong class="text-muted"><?php echo e($product->title); ?></strong>
                        <p class="mt-1 text-muted" id="selected-chart-price-title"></p>
                        <div>
                            <div id="empty-chart" class="empty-chart" style="display: none">
                                <p><?php echo e(trans('front::messages.products.thirty-day-change')); ?></p>
                            </div>
                            <div id="chart" class="ltr"></div>
                        </div>
                        <ul class="chart-prices-label">
                            <?php $__currentLoopData = $product->prices()->orderBy('stock', 'desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chart_price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $label = $chart_price->getAttributesName();
                                ?>
                                <li>
                                    <label data-action="<?php echo e(route('front.products.priceChart', ['price' => $chart_price])); ?>" data-title="<?php echo e($chart_price->getAttributesName()); ?>" title="<?php echo e($chart_price->getAttributesName()); ?>">
                                        <span><?php echo e($label != '' ? $label : $product->title); ?></span>
                                    </label>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if(option('show_product_share_links', 1) == 1): ?>
        <!-- Modal -->
        <div class="modal fade" id="shareproduct" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title" id="exampleModalLabel">اشتراک گذاری</h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">



                    <div><p>با استفاده از روش‌های زیر می‌توانید این صفحه را با دوستان خود به اشتراک بگذارید.</p></div>
                    <ul class="share-product">

                        <a target="_blank" class="telegram" href="https://t.me/share/url?url=<?php echo e(route('front.products.shortLink', ['id' => $product->id])); ?>">
                            <li  class="custom-mdi mdi mdi-telegram"></li>
                        </a>

                        <a target="_blank" class="whatsapp" href="https://api.whatsapp.com/send?text=<?php echo e(route('front.products.shortLink', ['id' => $product->id])); ?>">
                            <li  class="custom-mdi mdi mdi-whatsapp"></li>
                        </a>
                        <a target="_blank" class="twiiter" href="https://twitter.com/intent/tweet?url=<?php echo e(route('front.products.shortLink', ['id' => $product->id])); ?>">
                            <li  class="custom-mdi mdi mdi-twitter"></li>
                        </a>
                        <a target="_blank" class="linkedin" href="https://www.linkedin.com/sharing/share-offsite/?url= <?php echo e(route('front.products.shortLink', ['id' => $product->id])); ?>">
                            <li  class="custom-mdi mdi mdi-linkedin"></li>
                        </a>
                    </ul>
                    <hr>
                    <div class="filed-link dir-ltr copy-text">

                        <input id="shareLink" type="text" disabled value="<?php echo e(route('front.products.shortLink', ['id' => $product->id])); ?>" readonly="">

                        <div class="copy-text-btn" data-toggle="tooltip" data-placement="right" title="" data-original-title="کپی لینک">
                            <i class="mdi mdi-content-copy"></i>
                        </div>
                    </div>
                </div>

              </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- product review add modal -->
    <?php if(auth()->check()): ?>
        <?php echo $__env->make('front::products.partials.add-review', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
    <!-- product review add modal -->

    <?php echo $__env->make('front::products.partials.sizes-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(theme_asset('js/vendor/jquery.fancybox.min.js')); ?>"></script>
    <script src="<?php echo e(theme_asset('js/plugins/apexcharts/apexcharts.js')); ?>"></script>
    <script src="<?php echo e(theme_asset('js/pages/products/show.js')); ?>?v=21"></script>
    <script src="<?php echo e(theme_asset('js/pages/comments.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('front::layouts.master', ['title' => $product->meta_title ?: $product->title], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/akoonli1/public_html/themes/DefaultTheme/src/resources/views/products/show.blade.php ENDPATH**/ ?>