<meta property="og:locale" content="fa_IR" />
<meta property="og:title" content="<?php echo e($product->meta_title ?: $product->title); ?>" />
<meta property="og:type" content="product" />
<meta property="og:url" content="<?php echo e(route('front.products.show', ['product' => $product])); ?>" />
<meta property="og:description" content="<?php echo e($product->meta_description ?: $product->short_description); ?>">
<meta name="keywords" content="<?php echo e($product->getTags); ?>">
<meta name="product_id" content="<?php echo e($product->id); ?>">
<link rel="canonical" href="<?php echo e(route('front.products.show', ['product' => $product])); ?>" />

<meta name="product_name" content="<?php echo e($product->title); ?>">
<meta name="product_price" content="<?php echo e($product->getLowestPrice(true, true)); ?>">
<meta name="product_old_price" content="<?php echo e($product->getLowestDiscount(true, true)); ?>">

<meta name="price" content="<?php echo e($product->getLowestPrice(true, true)); ?>">

<?php if($product->image): ?>
    <meta property="og:image" content="<?php echo e(asset($product->image)); ?>">
    <meta property="og:image:width" content="600" />
    <meta property="og:image:height" content="600" />
<?php endif; ?>

<?php if($product->addableToCart()): ?>
    <meta property="product:availability" content="in stock">
    <meta property="product:price:amount" content="<?php echo e($product->getLowestPrice(true, true)); ?>">
    <meta property="product:price:currency" content="IRR">
    <meta name="availability" content="https://schema.org/InStock">
<?php else: ?>
    <meta property="product:availability" content="out of stock">
    <meta name="availability" content="https://schema.org/OutOfStock">
<?php endif; ?>

<script type="application/ld+json">
    {
        "@context": "https://schema.org/",
        "@type": "Product",
        "name": "<?php echo e($product->meta_title ?: $product->title); ?>",
        <?php if($product->title_en): ?>
        "alternateName": "<?php echo e($product->title_en); ?>",
        <?php endif; ?>
        "image": [
<?php
    $images = collect([$product->image]);
    if ($product->gallery()->count()) {
        $images = $images->merge($product->gallery->pluck('image'));
    }
?>
    <?php echo $images->map(fn($img) => '"' . asset($img) . '"')->implode(', '); ?>

    ],

        <?php if($product->brand): ?>
        "brand": {
            "@type": "Brand",
            "name": "<?php echo e($product->brand->name); ?>"
        },
        <?php endif; ?>

        "offers": {
            "@type": "Offer",
            "url": "<?php echo e(route('front.products.show', ['product' => $product])); ?>",
            "priceCurrency": "IRR",
            "price": "<?php echo e($product->getLowestPrice(true, true)); ?>",
            <?php if($product->addableToCart()): ?>
            "availability": "https://schema.org/InStock"
            <?php else: ?>
            "availability": "https://schema.org/OutOfStock"
            <?php endif; ?>
        },

        "description": <?php echo json_encode($product->meta_description ?: $product->short_description); ?>

    }
</script>
<?php /**PATH /home/akoonli1/public_html/themes/DefaultTheme/src/resources/views/products/partials/product-meta.blade.php ENDPATH**/ ?>