<?php $__env->startPush('meta'); ?>


<?php if(option('allow_indexing_product_page') == "off"): ?>
    <meta name="robots" content="noindex, nofollow">
    <meta name="googlebot" content="noindex, nofollow">
    <meta name="bingbot" content="noindex, nofollow">

<?php else: ?>
    <meta name="robots" content="index, follow"/>
    <meta name="googlebot" content="index, follow">
    <meta name="bingbot" content="index, follow">
<?php endif; ?>
    <meta name="description" content="<?php echo e(option('info_short_description')); ?>">
    <meta name="keywords" content="<?php echo e(option('info_tags')); ?>">
    <link rel="canonical" href="<?php echo e(route('front.products.index')); ?>" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <!-- Start main-content -->
    <main class="main-content dt-sl mt-4 mb-3">
        <div class="container main-container">

            <div class="row">

                <div class="col-lg-12 col-md-12 col-sm-12 search-card-res">
                    <!-- Start Content -->
                    <div class="title-breadcrumb-special dt-sl mb-3">
                        <div class="breadcrumb dt-sl">
                            <nav>
                                <a href="/"><?php echo e(trans('front::messages.products.home')); ?></a>
                                <span><?php echo e(trans('front::messages.products.products')); ?></span>
                            </nav>
                        </div>
                    </div>
                    <?php if($categories->count()): ?>
                        <div class="dt-sl dt-sn px-0 search-amazing-tab">
                            <div class="row mb-3 mx-0 px-res-0">

                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-lg-3 col-md-4 col-sm-6 col-12 px-10 mb-1 px-res-0">
                                        <div class="product-card mb-2 mx-res-0 category-index">
                                            <div class="product-card-body">
                                                <h5 class="product-title">
                                                    <a href="<?php echo e(route('front.products.category', ['category' => $category])); ?>"><?php echo e($category->title); ?></a>
                                                </h5>
                                            </div>
                                            <a class="product-thumb" href="<?php echo e(route('front.products.category', ['category' => $category])); ?>">
                                                <img data-src="<?php echo e($category->image); ?>" alt="<?php echo e($category->title); ?>">
                                            </a>

                                            <a href="<?php echo e(route('front.products.category', ['category' => $category])); ?>" class="more-cat"><?php echo e(trans('front::messages.products.view-products')); ?></a>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>

                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('front::partials.empty', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
                <!-- End Content -->
            </div>

        </div>
    </main>
    <!-- End main-content -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('front::layouts.master', ['title' => trans('front::messages.products.products')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/akoonli1/public_html/themes/DefaultTheme/src/resources/views/products/index.blade.php ENDPATH**/ ?>