<!-- Product Info -->
<div class="col-lg-8 mt-3 col-md-12 pb-5 product-info-block">
    <div class="product-info dt-sl">
        <div class="product-title">
            <h1><?php echo e($product->title); ?></h1>
            <h3 class="mb-1"><?php echo e($product->title_en); ?></h3>
        </div>

        <div class="row pt-2">
            <div class="col-md-7 col-lg-7">
                <hr class="border-product-title">
                <div class="row mt-2">
                    <?php if($product->rating): ?>
                        <div class="col-12 d-flex">
                            <div class="d-flex">
                                <i class="mdi mdi mdi-star text-warning mx-0"></i>
                                <p class="mx-1 mb-2"><?php echo e($product->rating); ?></p>
                                <p class="mx-1 mb-2 text-muted">(<?php echo e($product->reviews_count); ?>)</p>
                            </div>
                            <div class="d-flex">
                                <p class="text-primary font-weight-bold mx-2 mb-2"><?php echo e(trans('front::messages.products.review')); ?> <?php echo e($product->reviews_count); ?></p>
                                <p class="text-primary font-weight-bold mx-2 mb-2"><?php echo e(trans('front::messages.products.comment-count')); ?> <?php echo e($product->comments()->accepted()->count()); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if($product->suggestionCount()): ?>
                        <div class="col-12 d-flex">
                            <i class="mdi mdi mdi-thumb-up-outline text-success mx-0"></i>
                            <p class="text-muted commodity mx-2"> <span><?php echo e($product->suggestionPercent()); ?>%</span>(<?php echo e($product->suggestionCount()); ?>) نفر از خریداران این کالا را پیشنهاد کردن </p>
                        </div>
                    <?php endif; ?>
                </div>
                <?php if($product->short_description): ?>
                    <p class="little-des pt-0 mt-0"><?php echo nl2br($product->short_description); ?></p>
                <?php endif; ?>

                <?php
                    $specialSpecifications = $product->specialSpecifications();
                ?>

                <?php if($specialSpecifications->count()): ?>
                    <div class="product-params dt-sl">
                        <ul class="mt-0" data-title=" <?php echo e(trans('front::messages.products.product-features')); ?>">
                            <?php $__currentLoopData = $specialSpecifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <span><?php echo e($specification->name); ?>: </span>
                                    <span> <?php echo e($specification->pivot->value); ?> </span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <?php if($specialSpecifications->count() > 2): ?>
                            <div class="sum-more">
                                <span class="show-more btn-link-border">
                                    <?php echo e(trans('front::messages.products.more-items')); ?>

                                </span>
                                <span class="show-less btn-link-border">
                                    <?php echo e(trans('front::messages.products.to-close')); ?>


                                </span>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <?php if($product->brand): ?>
                    <div class="d-block mb-2">
                        <span class="font-weight-bold"><?php echo e(trans('front::messages.products.brand')); ?>:</span>
                        <a href="<?php echo e(route('front.brands.show', ['brand' => $product->brand])); ?>" class="link--with-border-bottom"><?php echo e($product->brand->name); ?></a>
                    </div>
                <?php endif; ?>

                <?php if($product->sizeType): ?>
                    <div class="mt-3 size-guide">
                        <img src="<?php echo e(theme_asset('img/size.png')); ?>" alt="size">
                        <a href="javascript:void(0)" data-toggle="modal" data-target="#size-modal" class="mt-4 link--with-border-bottom">راهنمای سایزبندی</a>
                    </div>
                <?php endif; ?>
            </div>


            <div class="col-xl-4 col-md-5 col-sm-8 mx-sm-auto mx-0">

                <?php if($product->labels->count()): ?>
                    <div class="row mr-1 mb-2">
                        <div class="btn-group" role="group">
                            <?php $__currentLoopData = $product->labels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="btn-border badge text-white ml-1 bg-primary"><?php echo e($label->title); ?></span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if($product->isPhysical()): ?>
                    <div class="card box-card px-3 pb-3 pt-0">
                        <div class="box-border"></div>

                        <?php if($product->getPrices->count()): ?>

                            <?php
                                $prev_attribute = null;
                                $groups = null;
                                $attributes_id = [];
                                $group_loop = 0;
                            ?>

                            <?php $__currentLoopData = $attributeGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attributeGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($product->get_attributes($attributeGroup, $prev_attribute, $groups, $attributes_id)): ?>
                                    <?php
                                        $checked = false;
                                        $group_checked = false;
                                        $prev_selected_attr = $attributes_id;
                                    ?>


                                    <div class="product-variant dt-sl <?php echo e($attributeGroup->type == 'color' ? 'product-variant-color' : ''); ?>">
                                        <div class="section-title d-flex align-items-baseline text-sm-title no-after-title-wide mb-1">
                                            <span class="mdi mdi-checkbox-blank-circle-outline"></span>
                                            <h2 class=" mb-0 mx-1 d-block"><?php echo e($attributeGroup->name); ?>: <span id="attributeGroup-<?php echo e($attributeGroup->id); ?>"></span></h2>
                                        </div>
                                        <ul class="product-variants float-right ml-3 <?php echo e($attributeGroup->type == 'select' ? 'mt-2' : ''); ?>">
                                            <?php $__currentLoopData = $product->get_attributes($attributeGroup, $prev_attribute, $groups, $attributes_id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php

                                                    if ($group_loop != 0 && count($prev_selected_attr)) {
                                                        $has_stock = $product->hasAttributeStock($attribute, $prev_selected_attr);
                                                    } else {
                                                        $has_stock = $product->hasAttributeStock($attribute);
                                                    }

                                                    if ($selected_price->get_attributes()->find($attribute->id)) {
                                                        $checked = true;
                                                        $prev_attribute = $attribute;
                                                        $attributes_id[] = $attribute->id;
                                                        $group_checked = true;
                                                    } else {
                                                        $checked = false;
                                                    }

                                                    if ($loop->last && $checked == false && $group_checked == false) {
                                                        $checked = true;
                                                        $prev_attribute = $attribute;
                                                        $attributes_id[] = $attribute->id;
                                                    }

                                                ?>

                                                <li class="ui-variant product-attribute <?php echo e($has_stock ? '' : 'unavailable'); ?>" title="<?php echo e($has_stock ? '' : 'ناموجود'); ?>">
                                                    <label class="ui-variant mb-0 <?php echo e($attributeGroup->type == 'color' ? 'ui-variant--color' : ''); ?>">

                                                        <?php if($attributeGroup->type == 'color'): ?>
                                                            <span data-color-id="<?php echo e($attribute->id); ?>" data-group-id="attributeGroup-<?php echo e($attributeGroup->id); ?>" data-name="<?php echo e($attribute->name); ?>" data-container="body" data-toggle="popover" data-placement="bottom" data-trigger="hover" class="ui-variant-shape" style="background-color: <?php echo e($attribute->value); ?>" <?php echo e($checked ? 'checked' : ''); ?>></span>
                                                        <?php endif; ?>

                                                        <input data-product="<?php echo e($product->slug); ?>" type="radio" value="<?php echo e($attribute->id); ?>" name="attributes_group[<?php echo e($loop->parent->iteration); ?>][]" class="variant-selector" <?php echo e($checked ? 'checked' : ''); ?> <?php echo e($has_stock ? '' : 'disabled'); ?>>

                                                        <div class="ui-variant--check <?php echo e($attributeGroup->type == 'select' ? 'select' : ''); ?>">
                                                            <span <?php echo e($attributeGroup->type != 'color' ? 'product-warranty-span' : ''); ?>><?php echo e($attributeGroup->type != 'color' ? $attribute->name : ''); ?></span>
                                                        </div>
                                                    </label>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>

                                    <?php
                                        $groups[] = $attributeGroup;
                                        $group_loop++;
                                    ?>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <?php
                                $selected_price = $product->getPriceWithAttributes($attributes_id);
                            ?>

                        <?php endif; ?>

                        <div class="dt-sl box-Price-number box-margin">
                            <?php if($product->addableToCart()): ?>
                                <div class="mb-2 d-flex ">
                                    <span class="flex-grow-1 number"><?php echo e($product->getUnit()); ?></span>
                                    <div class="flex-grow-1 text-centertext-price d-flex align-items-center">
                                        <div class="number-input">
                                            <button type="button" onclick="this.parentNode.querySelector('input[type=number]').stepDown()"></button>
                                            <input id="cart-quantity" class="quantity" min="<?php echo e(cart_min($selected_price)); ?>" max="<?php echo e(cart_max($selected_price)); ?>" value="<?php echo e(cart_min($selected_price)); ?>" type="number" required>
                                            <button type="button" onclick="this.parentNode.querySelector('input[type=number]').stepUp()" class="plus"></button>
                                        </div>
                                    </div>
                                </div>
                                <div class="section-title text-sm-title no-after-title-wide mb-0 dt-sl">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="d-flex justify-content-between mt-4">
                                                <div class="text-price d-flex align-items-center">
                                                    <?php echo e(trans('front::messages.products.price')); ?>

                                                </div>
                                                <div class="row">
                                                    <div class="col-12 d-flex justify-content-end">
                                                        <?php if($selected_price->hasDiscount()): ?>
                                                            <del>
                                                                <?php echo e(number_format($selected_price->regularPrice())); ?>

                                                            </del>
                                                            <div class="discount show-discount mr-3 ">
                                                                <span><?php echo e($selected_price->discount()); ?>%</span>
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                    <div class="col-12 text-left">
                                                        <span class="price text-danger">
                                                            <?php echo e(trans('front::messages.currency.prefix')); ?>

                                                            <?php echo e(number_format($selected_price->salePrice())); ?>

                                                        </span>
                                                        <span class="currency">
                                                            <?php echo e(trans('front::messages.currency.suffix')); ?>

                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>

                                <button data-price_id="<?php echo e($selected_price->id); ?>" data-image="<?php echo e($selected_price->image ? asset($selected_price->image->image) : ''); ?>" data-action="<?php echo e(route('front.cart.store', ['product' => $product])); ?>" data-product="<?php echo e($product->slug); ?>" type="button" class=" mt-4 w-100 btn-primary-cm btn-with-icon add-to-cart btn-show-product">
                                    <?php echo e(trans('front::messages.products.add-to-cart')); ?>

                                </button>
                            <?php elseif(!$product->addableToCart()): ?>
                                <div class="infoSection">
                                    <div class="box-product-unavailable">
                                        <div class="unavailable d-flex justify-content-center">
                                            <h5 class=""><?php echo e(trans('front::messages.products.unavailable')); ?></h5>
                                        </div>
                                        <p class="text-justify"><?php echo e(trans('front::messages.products.text-unavailable')); ?></p>
                                    </div>
                                    <div class="text-center">
                                        <button id="stock_notify_btn" data-user="<?php echo e(auth()->check() ? auth()->user()->id : ''); ?>" data-product="<?php echo e($product->id); ?>" type="button" class="btn-primary-cm bg-secondary btn-with-icon cart-not-available ">
                                            <i class="mdi mdi-information"></i>
                                            <?php echo e(trans('front::messages.products.let-me-know')); ?>

                                        </button>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/akoonli1/public_html/themes/DefaultTheme/src/resources/views/products/partials/product-info.blade.php ENDPATH**/ ?>