<?php $__env->startSection('content'); ?>

    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb no-border">
                                    <li class="breadcrumb-item">مدیریت
                                    </li>
                                    <li class="breadcrumb-item">مدیریت محصولات
                                    </li>
                                    <li class="breadcrumb-item active">ویرایش محصول
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <div id="main-card" class="content-body">
                <form class="form" id="product-edit-form" action="<?php echo e(route('admin.products.update', ['product' => $product])); ?>" data-redirect="<?php echo e(route('admin.products.index')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('put'); ?>

                    <div class="row match-height">
                        <div class="col-md-12">
                            <div class="card overflow-hidden">
                                <div class="card-header">
                                    <h4 class="card-title">اطلاعات محصول "<?php echo e($product->title); ?>"</h4>
                                    <a target="_blank" href="<?php echo e($product->link()); ?>" class="btn btn-success">مشاهده محصول</a>
                                </div>
                                <div class="card-content">
                                    <div class="card-body">

                                        <div class="nav-vertical">
                                            <ul class="nav nav-tabs nav-left flex-column" role="tablist">
                                                <li class="nav-item">
                                                    <a class="nav-link active" id="baseVerticalLeft-tab1" data-toggle="tab" aria-controls="tabVerticalLeft1" href="#tabVerticalLeft1" role="tab" aria-selected="true">اطلاعات کلی</a>
                                                </li>
                                                <li class="nav-item">
                                                    <a class="nav-link" id="productMetaTab" data-toggle="tab" aria-controls="tabProductMeta" href="#tabProductMeta" role="tab" aria-selected="false">سئو</a>
                                                </li>
                                                <li class="nav-item physical-item">
                                                    <a class="nav-link" id="product-prices-tab-nav" data-toggle="tab" aria-controls="product-prices-tab" href="#product-prices-tab" role="tab" aria-selected="false">قیمت</a>
                                                </li>
                                                <li class="nav-item download-item">
                                                    <a class="nav-link" id="product-files-tab-nav" data-toggle="tab" aria-controls="product-files-tab" href="#product-files-tab" role="tab" aria-selected="false">فایل</a>
                                                </li>
                                                <li class="nav-item">
                                                    <a class="nav-link" id="productImageTab" data-toggle="tab" aria-controls="tabProductImage" href="#tabProductImage" role="tab" aria-selected="false">تصاویر</a>
                                                </li>
                                                <li class="nav-item">
                                                    <a class="nav-link" id="specification-tab" data-toggle="tab" aria-controls="tabSpecification" href="#tabSpecification" role="tab" aria-selected="false">مشخصات</a>
                                                </li>
                                                <li class="nav-item">
                                                    <a class="nav-link" id="torob-tab" data-toggle="tab" aria-controls="tabTorob" href="#tabTorob" role="tab" aria-selected="false">ترب</a>
                                                </li>
                                                <li class="nav-item physical-item">
                                                    <a class="nav-link" id="sizes-tab" data-toggle="tab" aria-controls="tabSize" href="#tabSize" role="tab" aria-selected="false">سایز بندی</a>
                                                </li>

                                            </ul>
                                            <div class="tab-content">
                                                <div class="tab-pane active" id="tabVerticalLeft1" role="tabpanel" aria-labelledby="baseVerticalLeft-tab1">
                                                    <div class="col-md-12">
                                                        <div class="form-body">

                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>عنوان</label>
                                                                        <input type="text" class="form-control" name="title" value="<?php echo e($product->title); ?>">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>عنوان انگلیسی</label>
                                                                        <input type="text" class="form-control" name="title_en" value="<?php echo e($product->title_en); ?>">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>دسته بندی اصلی</label>
                                                                        <select class="form-control product-category" name="category_id">
                                                                            <option value="">انتخاب کنید</option>
                                                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <option class="l<?php echo e($category->parents()->count() + 1); ?> <?php echo e($category->categories()->count() ? 'non-leaf' : ''); ?>" data-pup="<?php echo e($category->category_id); ?>" <?php echo e($product->category_id == $category->id ? 'selected' : ''); ?> value="<?php echo e($category->id); ?>"><?php echo e($category->title); ?>

                                                                                </option>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </select>
                                                                    </div>
                                                                </div>

                                                                <div class="col-md-6 col-12">
                                                                    <div class="form-group">
                                                                        <label>نوع محصول</label>
                                                                        <select name="type" id="product-type" class="form-control">
                                                                            <option value="physical" <?php echo e($product->isPhysical() ? 'selected' : ''); ?>>محصول فیزیکی</option>
                                                                            <option value="download" <?php echo e($product->isDownload() ? 'selected' : ''); ?>>محصول دانلودی</option>
                                                                        </select>
                                                                    </div>
                                                                </div>

                                                                <div class="col-md-3 col-12 physical-item">
                                                                    <div class="form-group">
                                                                        <label>برند</label>
                                                                        <input id="brand" type="text" class="form-control" name="brand" value="<?php echo e($product->brand ? $product->brand->name : ''); ?>">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-3 col-12 physical-item">
                                                                    <div class="form-group">
                                                                        <label>وزن (گرم)</label>
                                                                        <input type="number" class="form-control" name="weight" value="<?php echo e($product->weight); ?>">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-3 col-12 physical-item">
                                                                    <div class="form-group">
                                                                        <label>واحد</label>
                                                                        <input type="text" class="form-control" name="unit" value="<?php echo e($product->unit); ?>">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-12">
                                                                    <div class="form-group">
                                                                        <label>دسته بندی ها</label>
                                                                        <select class="form-control product-categories" name="categories[]" multiple>
                                                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <option class="l<?php echo e($category->parents()->count() + 1); ?> <?php echo e($category->categories()->count() ? 'non-leaf' : ''); ?>" data-pup="<?php echo e($category->category_id); ?>" <?php echo e($product->categories()->find($category->id) ? 'selected' : ''); ?> value="<?php echo e($category->id); ?>"><?php echo e($category->title); ?>

                                                                                </option>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <fieldset class="form-group">
                                                                        <label>برچسب</label>
                                                                        <input type="text" name="labels" class="form-control labels" data-action="<?php echo e(route('admin.get-labels')); ?>" value="<?php echo e($product->getLabels()); ?>">
                                                                    </fieldset>
                                                                </div>

                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>توضیحات کوتاه</label>
                                                                        <textarea class="form-control" name="short_description" rows="4"><?php echo e($product->short_description); ?></textarea>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-12">
                                                                    <div class="form-group">
                                                                        <label for="first-name-vertical">توضیحات</label>
                                                                        <textarea id="description" class="form-control" rows="3" name="description"><?php echo e($product->description); ?></textarea>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="tab-pane" id="product-prices-tab" role="tabpanel" aria-labelledby="product-prices-tab-nav">

                                                    <div class="card collapse-icon accordion-icon-rotate product-prices-tab">

                                                        <div class="card-body">

                                                            <div class="row prices-option-div">

                                                                <div class="col-md-3 col-12">
                                                                    <div class="form-group">
                                                                        <label>انتخاب ارز</label>
                                                                        <select name="currency_id" class="form-control">
                                                                            <option data-amount="1" data-title="تومان" value="">تومان (پیش فرض)</option>
                                                                            <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <option data-amount="<?php echo e($currency->amount); ?>" data-title="<?php echo e($currency->title); ?>" value="<?php echo e($currency->id); ?>" <?php echo e($product->currency && $product->currency->id == $currency->id ? 'selected' : ''); ?>><?php echo e($currency->title); ?></option>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-3 col-12">
                                                                    <div class="form-group">
                                                                        <label>گرد کردن</label>
                                                                        <select name="rounding_amount" class="form-control">
                                                                            <option data-value="<?php echo e(option('default_rounding_amount', 'no')); ?>" value="default" <?php echo e($product->rounding_amount == 'default' ? 'selected' : ''); ?>>پیشفرض</option>
                                                                            <option data-value="no" value="no" <?php echo e($product->rounding_amount == 'no' ? 'selected' : ''); ?>>خیر</option>
                                                                            <option data-value="100" value="100" <?php echo e($product->rounding_amount == '100' ? 'selected' : ''); ?>>100 تومان</option>
                                                                            <option data-value="1000" value="1000" <?php echo e($product->rounding_amount == '1000' ? 'selected' : ''); ?>>1000 تومان</option>
                                                                            <option data-value="10000" value="10000" <?php echo e($product->rounding_amount == '10000' ? 'selected' : ''); ?>>10000 تومان</option>
                                                                            <option data-value="100000" value="100000" <?php echo e($product->rounding_amount == '100000' ? 'selected' : ''); ?>>100000 تومان</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-3">
                                                                    <div class="form-group">
                                                                        <label>نحوه گرد کردن</label>
                                                                        <select name="rounding_type" class="form-control">
                                                                            <option data-value="<?php echo e(option('default_rounding_type', 'close')); ?>" value="default" <?php echo e($product->rounding_type == 'default' ? 'selected' : ''); ?>>پیشفرض</option>
                                                                            <option data-value="close" value="close" <?php echo e($product->rounding_type == 'close' ? 'selected' : ''); ?>>نزدیک</option>
                                                                            <option data-value="up" value="up" <?php echo e($product->rounding_type == 'up' ? 'selected' : ''); ?>>رو به بالا</option>
                                                                            <option data-value="down" value="down" <?php echo e($product->rounding_type == 'down' ? 'selected' : ''); ?>>رو به پایین</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-12">
                                                                    <hr>
                                                                </div>
                                                            </div>

                                                            <div id="product-prices-div" class="product-prices-div">
                                                                <?php if($product->isPhysical()): ?>
                                                                    <?php $__currentLoopData = $product->prices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <?php echo $__env->make('back.products.partials.prices-include', ['price' => $price], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php endif; ?>
                                                            </div>

                                                            <div class="row">
                                                                <div class="col-12 text-center mt-2">
                                                                    <button id="add-product-prices" type="button" class="btn btn-outline-primary waves-effect waves-light"><i class="feather icon-plus"></i> افزودن قیمت</button>
                                                                    <button id="copy-product-prices" type="button" class="btn btn-outline-primary waves-effect waves-light"><i class="feather icon-copy"></i> کپی آخرین قیمت</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="tab-pane" id="product-files-tab" role="tabpanel" aria-labelledby="product-files-tab-nav">

                                                    <div class="col-md-12">
                                                        <div id="product-files-area">
                                                            <?php if($product->isDownload()): ?>
                                                                <?php $__currentLoopData = $product->prices()->orderBy('ordering')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php echo $__env->make('back.products.partials.files-include', ['price' => $price], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-12 text-center mt-2">
                                                                <button id="add-product-file" type="button" class="btn btn-outline-primary waves-effect waves-light"><i class="feather icon-plus"></i> افزودن فایل</button>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="tab-pane" id="tabSpecification" role="tabpanel" aria-labelledby="specification-tab">
                                                    <div id="specifications-card" class="card">
                                                        <div class="card-header d-flex justify-content-between align-items-end">
                                                            <h4 class="card-title">مشخصات محصول</h4>
                                                            <p class="font-medium-5 mb-0"><i class="feather icon-help-circle text-muted cursor-pointer"></i></p>
                                                        </div>
                                                        <div class="card-content">
                                                            <div class="card-body ">
                                                                <div class="row">
                                                                    <div class="col-md-7 text-justify">
                                                                        <p>در این بخش میتوانید مشخصات محصول را وارد کنید. دقت کنید که محصولات بر اساس نوع مشخصات با یکدیگر مقایسه میشوند. به عنوان مثال یک محصول با نوع مشخصات "گوشی موبایل" فقط با محصولات این نوع مقایسه میشود</p>
                                                                    </div>
                                                                    <div class="col-md-4">
                                                                        <div class="form-group">
                                                                            <label>نوع مشخصات</label>
                                                                            <input id="specifications_type" class="form-control" name="spec_type" placeholder="مثلا گوشی موبایل" value="<?php echo e($product->specType ? $product->specType->name : ''); ?>">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="form-body pt-2">
                                                                    <div id="specifications-area">
                                                                        <?php $__currentLoopData = $product->specificationGroups->unique(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <div class="row mt-2 specification-group">
                                                                                <div class="col-12">
                                                                                    <div class="row group-row">
                                                                                        <div class="col-md-1">
                                                                                            <span>نام گروه</span>
                                                                                        </div>
                                                                                        <div class="col-md-10 form-group">
                                                                                            <input type="text" class="form-control group-input" data-group_name="<?php echo e($loop->index); ?>" name="specification_group[<?php echo e($loop->index); ?>][name]" placeholder="مثال: مشخصات کلی" value="<?php echo e($group->name); ?>" required>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                                <div class="all-specifications col-12">
                                                                                    <?php $__currentLoopData = $product->specifications()->where('specification_group_id', $group->id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                        <div class="single-specificition">
                                                                                            <div class="row">
                                                                                                <div class="col-md-1">
                                                                                                    <fieldset>
                                                                                                        <label>
                                                                                                            <input name="specification_group[<?php echo e($loop->parent->index); ?>][specifications][<?php echo e($loop->index); ?>][special]" type="checkbox" <?php echo e($specification->pivot->special ? 'checked' : ''); ?>>
                                                                                                        </label>
                                                                                                    </fieldset>
                                                                                                </div>
                                                                                                <div class="col-md-4 form-group">
                                                                                                    <p class="spec-label">عنوان</p>
                                                                                                    <input type="text" class="form-control spec-label" name="specification_group[<?php echo e($loop->parent->index); ?>][specifications][<?php echo e($loop->index); ?>][name]" placeholder="مثال: حافظه داخلی" value="<?php echo e($specification->name); ?>" required>
                                                                                                </div>

                                                                                                <div class="col-md-6 form-group">
                                                                                                    <p class="spec-label">مقدار</p>
                                                                                                    <textarea class="form-control spec-label" rows="1" name="specification_group[<?php echo e($loop->parent->index); ?>][specifications][<?php echo e($loop->index); ?>][value]" placeholder="مثال: 32 گیگابایت" required><?php echo e($specification->pivot->value); ?></textarea>
                                                                                                </div>
                                                                                                <div class="col-md-1">
                                                                                                    <button type="button" class="btn btn-flat-danger waves-effect waves-light remove-specification custom-padding"><i class="feather icon-minus"></i></button>
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                </div>

                                                                                <div class="col-md-12 text-center">
                                                                                    <button type="button" class="btn btn-flat-success waves-effect waves-light add-specifaction">افزودن مشخصات</button>
                                                                                    <button type="button" class="btn btn-flat-danger waves-effect waves-light remove-group">حذف گروه</button>

                                                                                </div>
                                                                            </div>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </div>

                                                                    <div class="row">
                                                                        <div class="col-12 text-center mt-4">
                                                                            <button id="add-product-specification-group" type="button" class="btn btn-outline-primary waves-effect waves-light"><i class="feather icon-plus"></i> افزودن گروه مشخصات</button>
                                                                        </div>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>

                                                <div class="tab-pane" id="tabProductMeta" role="tabpanel" aria-labelledby="productMetaTab">
                                                    <div class="col-md-12">
                                                        <div class="form-body">

                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>عنوان سئو</label>
                                                                        <input type="text" class="form-control" name="meta_title" value="<?php echo e($product->meta_title); ?>">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>url</label>
                                                                        <input id="slug" type="text" class="form-control" name="slug" value="<?php echo e($product->slug); ?>">
                                                                        <p>
                                                                            <small>
                                                                                <a id="generate-product-slug" href="#">ایجاد خودکار</a>
                                                                                <span id="slug-spinner" class="spinner-grow spinner-grow-sm text-success" role="status" style="display: none;">
                                                                                    <span class="sr-only">Loading...</span>
                                                                                </span>
                                                                            </small>
                                                                        </p>
                                                                    </div>
                                                                </div>

                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>توضیحات سئو</label>
                                                                        <textarea class="form-control" name="meta_description" rows="3"><?php echo e($product->meta_description); ?></textarea>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <fieldset class="form-group">
                                                                        <label>کلمات کلیدی</label>
                                                                        <input type="text" name="tags" class="form-control tags" data-action="<?php echo e(route('admin.get-tags')); ?>" value="<?php echo e($product->getTags); ?>">
                                                                    </fieldset>
                                                                </div>

                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>

                                                <?php echo $__env->make('back.products.partials.sizes-tab', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                                <?php echo $__env->make('back.products.partials.torob-tab', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                                <div class="tab-pane overflow-hidden" id="tabProductImage" role="tabpanel" aria-labelledby="productImageTab">
                                                    <div class="col-md-12">
                                                        <div class="form-body">

                                                            <div class="row">
                                                                <div class="col-md-12">
                                                                    <label>تصاویر محصول ( <small>بهترین اندازه <span class="text-danger"><?php echo e(config('front.imageSizes.productGalleryImage')); ?></span> پیکسل میباشد.</small> )</label>

                                                                    <div class="dropzone dropzone-area mb-2" id="product-images">
                                                                        <div class="dz-message">تصاویر را به اینجا بکشید</div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <fieldset class="form-group">
                                                                        <label>تصویر شاخص</label>
                                                                        <div class="custom-file">
                                                                            <input id="image" type="file" accept="image/*" name="image" class="custom-file-input">
                                                                            <label class="custom-file-label" for="image"><?php echo e($product->image); ?></label>
                                                                            <p><small>بهترین اندازه <span class="text-danger"><?php echo e(config('front.imageSizes.productImage')); ?></span> پیکسل میباشد.</small></p>
                                                                        </div>
                                                                    </fieldset>
                                                                </div>

                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label>متن جایگزین تصویر</label>
                                                                        <input type="text" class="form-control" name="image_alt" value="<?php echo e($product->image_alt); ?>">
                                                                    </div>
                                                                </div>

                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="card">

                        <div class="card-content">
                            <div class="card-body">
                                <div class="form-body">

                                    <div class="row">
                                        <div class="col-md-3 col-12">
                                            <div class="form-group">
                                                <label>تاریخ ایجاد</label>
                                                <input autocomplete="off" type="text" data-timestamps="true" class="form-control persian-date-picker ltr" name="created_at" value="<?php echo e(jdate($product->created_at)->getTimestamp()); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-3 col-12">
                                            <div class="form-group">
                                                <label>تاریخ انتشار</label>
                                                <input id="publish_date" autocomplete="off" type="text" data-timestamps="true" class="form-control persian-date-picker ltr" name="publish_date" value="<?php echo e($product->publish_date ? jdate($product->publish_date)->getTimestamp() : jdate($product->created_at)->getTimestamp()); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <ul class="list-unstyled mb-0 mt-3">
                                                <li class="d-inline-block mr-2">
                                                    <fieldset>
                                                        <div class="custom-control custom-radio">
                                                            <input type="radio" class="custom-control-input" name="published" id="customRadio1" value="1" <?php echo e($product->published ? 'checked' : ''); ?>>
                                                            <label class="custom-control-label" for="customRadio1">انتشار</label>
                                                        </div>
                                                    </fieldset>
                                                </li>
                                                <li class="d-inline-block mr-2">
                                                    <fieldset>
                                                        <div class="custom-control custom-radio">
                                                            <input type="radio" class="custom-control-input" name="published" id="customRadio2" value="0" <?php echo e(!$product->published ? 'checked' : ''); ?>>
                                                            <label class="custom-control-label" for="customRadio2">پیش نویس</label>
                                                        </div>
                                                    </fieldset>
                                                </li>

                                            </ul>
                                        </div>
                                    </div>


                                    <div class="row mb-2">
                                        <div class="col-md-3">
                                            <fieldset class="checkbox">
                                                <div class="vs-checkbox-con vs-checkbox-primary">
                                                    <input type="checkbox" name="special" <?php echo e($product->special ? 'checked' : ''); ?>>
                                                    <span class="vs-checkbox">
                                                        <span class="vs-checkbox--check">
                                                            <i class="vs-icon feather icon-check"></i>
                                                        </span>
                                                    </span>
                                                    <span>محصول ویژه؟</span>
                                                </div>
                                            </fieldset>
                                        </div>
                                        <?php if(option('stock-amount-increased_sms') == 'on'): ?>
                                            <div class="col-md-5">
                                                <fieldset class="checkbox">
                                                    <div class="vs-checkbox-con vs-checkbox-primary">
                                                        <!-- فیلد مخفی برای ارسال مقدار false به صورت پیش‌فرض -->
                                                        <input type="hidden" name="stock_increase_sms" value="false">
                                                        <!-- چک‌باکس برای ارسال مقدار true -->
                                                        <input type="checkbox" name="stock_increase_sms" value="true">
                                                        <span class="vs-checkbox">
                                                        <span class="vs-checkbox--check">
                                                            <i class="vs-icon feather icon-check"></i>
                                                        </span>
                                                        </span>
                                                        <span>ارسال پیامک موجود شدن کالا به کاربران لیست به من اطلاع دهید</span>
                                                    </div>
                                                </fieldset>
                                            </div>
                                        <?php endif; ?>

                                    </div>
                                    <div id="special-end-date-container" class="row" style="display: hidden;">
                                        <div class="col-md-3 col-12">
                                            <div class="form-group">
                                                <label>تاریخ انقضای ویژه بودن محصول</label>
                                                <input type="text" name="special_end_date" class="form-control persian-date-picker" data-timestamps="true" value="<?php echo e($product->special_end_date ? jdate($product->special_end_date)->getTimestamp() : ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mt-3">
                                        <div class="col-12 text-center">
                                            <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">ویرایش محصول</button>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>

                    </div>


                </form>
                <div id="form-progress" class="progress progress-bar-success progress-xl" style="display: none;">
                    <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" style="width:0%">0%</div>
                </div>
            </div>

        </div>
    </div>

    <?php echo $__env->make('back.products.partials.specification-template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('back.products.partials.prices-template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('back.products.partials.files-template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('back.partials.plugins', ['plugins' => ['ckeditor', 'jquery-tagsinput', 'jquery.validate', 'jquery-ui', 'jquery-ui-sortable', 'dropzone', 'persian-datepicker']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php
    $help_videos = [config('general.video-helpes.products-create')];
?>

<?php $__env->startPush('scripts'); ?>
    <script>
        /* load saved image gallery */
        var mockImages = [];
        <?php $__currentLoopData = $product->gallery()->orderBy('ordering')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            mockImages.push({
                name: '<?php echo e($image->image); ?>',
                galleryImage: true,
                type: 'image/jpeg',
                status: 'success',
                upload: {
                    filename: '<?php echo e($image->image); ?>',
                },
                prevFile: true,
                accepted: true,
                image: '<?php echo e($image->image); ?>',
                color_id: '<?php echo e($image->color_id); ?>',
            });
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        var product = <?php echo e($product->id); ?>;

        var groupCount = <?php echo e($product->specificationGroups->unique()->count()); ?>;
        var specificationCount = <?php echo e($product->specifications->unique()->count()); ?>;

        var availableTypes = [
            <?php $__currentLoopData = $specTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $spec_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                '<?php echo e($spec_type->name); ?>',
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ];

        var specifications_type_first_change = true;

        var priceCount = <?php echo e($product->prices()->count()); ?>;
        var filesCount = <?php echo e($product->files()->count()); ?>;
        var sizesCount = <?php echo e($product->sizes()->count()); ?>;
    </script>

    <script src="<?php echo e(asset('back/assets/js/pages/products/all.js')); ?>?v=13"></script>
    <script src="<?php echo e(asset('back/assets/js/pages/products/edit.js')); ?>?v=8"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('back.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/akoonli1/public_html/resources/views/back/products/edit.blade.php ENDPATH**/ ?>