<?php $__env->startPush('meta'); ?>
    <?php if(option('allow_indexing_categories') == "off"): ?>
    <meta name="robots" content="noindex, nofollow">
    <meta name="googlebot" content="noindex, nofollow">
    <meta name="bingbot" content="noindex, nofollow">

    <?php else: ?>
    <meta name="robots" content="index, follow"/>
    <meta name="googlebot" content="index, follow">
    <meta name="bingbot" content="index, follow">
    <?php endif; ?>
    <meta property="og:title" content="<?php echo e($category->meta_title ?: $category->title); ?>" />
    <meta property="og:url" content="<?php echo e(route('front.products.category-products', ['category' => $category])); ?>" />
    <meta name="description" content="<?php echo e($category->meta_description ?: $category->description); ?>">
    <meta name="keywords" content="<?php echo e($category->getTags); ?>">
    <link rel="canonical" href="<?php echo e(route('front.products.category-products', ['category' => $category])); ?>" />
<?php $__env->stopPush(); ?>

<?php $__env->startPush('befor-styles'); ?>
    <link rel="stylesheet" href="<?php echo e(theme_asset('css/vendor/nouislider.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php
    $has_filter = $category->getFilter();
?>

<?php $__env->startSection('content'); ?>

    <!-- Start main-content -->
    <main class="main-content dt-sl mt-4 mb-3">
        <div class="container main-container">

            <div class="row">
                <!-- Start Content -->
                <div class="title-breadcrumb-special dt-sl mb-3">
                    <div class="breadcrumb dt-sl">
                        <nav>
                            <a href="/"><?php echo e(trans('front::messages.products.home')); ?></a>
                            <a href="<?php echo e(route('front.products.index')); ?>"><?php echo e(trans('front::messages.products.products')); ?></a>

                            <?php $__currentLoopData = $category->parents(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(route('front.products.category', ['category' => $parent])); ?>"><?php echo e($parent->title); ?></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <span><?php echo e($category->title); ?></span>
                        </nav>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php if($has_filter): ?>
                    <?php echo $__env->make('front::products.partials.category-filters', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <div id="category-products-div" data-action="<?php echo e(route('front.products.category-products', ['category' => $category])); ?>" class="<?php echo e($category->getFilter() ? 'col-lg-9' : 'col-lg-12'); ?> col-md-12 col-sm-12">
                    <?php if($products->count()): ?>
                        <div class="dt-sl dt-sn px-0 search-amazing-tab">

                            <div class="row">
                                <div class="products-list-sort-type ah-tab-wrapper dt-sl">
                                    <div class="ah-tab dt-sl">
                                        <a class="ah-tab-item" data-sort="latest" <?php echo e(request('sort_type') == 'latest' || !request('sort_type') ? 'data-ah-tab-active=true' : ''); ?> href="#"><?php echo e(trans('front::messages.categories.the-newest')); ?></a>
                                        <a class="ah-tab-item" data-sort="view" <?php echo e(request('sort_type') == 'view' ? 'data-ah-tab-active=true' : ''); ?> href="#"><?php echo e(trans('front::messages.categories.the-most-visited')); ?></a>
                                        <a class="ah-tab-item" data-sort="sale" <?php echo e(request('sort_type') == 'sale' ? 'data-ah-tab-active=true' : ''); ?> href="#"><?php echo e(trans('front::messages.categories.bestselling')); ?></a>
                                        <a class="ah-tab-item" data-sort="cheapest" <?php echo e(request('sort_type') == 'cheapest' ? 'data-ah-tab-active=true' : ''); ?> href="#"><?php echo e(trans('front::messages.categories.cheapest')); ?></a>
                                        <a class="ah-tab-item" data-sort="expensivest" <?php echo e(request('sort_type') == 'expensivest' ? 'data-ah-tab-active=true' : ''); ?> href="#"><?php echo e(trans('front::messages.categories.most-expensive')); ?></a>
                                    </div>
                                </div>
                            </div>

                            <div class="row mb-3 mx-0 px-res-0">
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <div class="col-lg-3 col-md-4 col-sm-6 col-12 px-10 mb-1 px-res-0 category-product-div">
                                        <?php echo $__env->make('front::products.partials.product-card', ['product' => $product], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <?php echo e($products->appends(request()->all())->links('front::components.paginate')); ?>

                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('front::partials.empty', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>

            <?php if($category->description): ?>
                <div class="row mt-2">
                    <div class="dt-sl dt-sn search-amazing-tab mb-3 mx-3" >
                        <div class="row">

                            <div class="col-md-12 p-md-5 category-background" style="background-image: url(<?php echo e(asset($category->background_image)); ?>);">
                                <?php echo $category->description; ?>

                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

        </div>
    </main>
    <!-- End main-content -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>

    <script>
        var selected_min_price = <?php echo e(request('min_price') ?: $min_price); ?>;
        var selected_max_price = <?php echo e(request('max_price') ?: $max_price); ?>;
        var products_min_price = <?php echo e($min_price); ?>;
        var products_max_price = <?php echo e($max_price); ?>;
    </script>

    <script src="<?php echo e(theme_asset('js/pages/products/category.js')); ?>?v=6"></script>
    <script src="<?php echo e(theme_asset('js/vendor/nouislider.min.js')); ?>"></script>
    <script src="<?php echo e(theme_asset('js/vendor/wNumb.js')); ?>"></script>
    <script src="<?php echo e(theme_asset('js/vendor/ResizeSensor.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('front::layouts.master', ['title' => $category->title], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/akoonli1/public_html/themes/DefaultTheme/src/resources/views/products/category-products.blade.php ENDPATH**/ ?>