<?php if($sliders->count()): ?>
    <section class="card sliders-sortable">
        <div class="card-header">
            <h4 class="card-title"><?php echo e($title); ?></h4>
        </div>
        <div class="card-content">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped mb-0">
                        <thead>
                            <tr>
                                <th class="text-center">ردیف</th>
                                <th>تصویر</th>
                                <th>عنوان</th>
                                <th class="text-center">وضعیت</th>
                                <th class="text-center">عملیات</th>
                            </tr>
                        </thead>
                        <tbody id="sliders-sortable-<?php echo e($loop->index); ?>">
                            <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr id="slider-<?php echo e($slider->id); ?>">
                                    <td class="text-center draggable-handler">
                                        <div class="fonticon-wrap"><i class="feather icon-move"></i></div>
                                    </td>
                                    <td>
                                        <div class="slider-thumb">
                                            <img src="<?php echo e(asset($slider->image)); ?>" alt="avtar img holder">
                                        </div>
                                    </td>
                                    <td><?php echo e($slider->title ?: '--'); ?></td>
                                    <td class="text-center">
                                        <?php if($slider->published): ?>
                                            <div class="badge badge-pill badge-success badge-md">منتشر شده</div>
                                        <?php else: ?>
                                            <div class="badge badge-pill badge-danger badge-md">پیش نویس</div>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sliders.update')): ?>
                                            <a href="<?php echo e(route('admin.sliders.edit', ['slider' => $slider])); ?>" class="btn btn-info mr-1 waves-effect waves-light">ویرایش</a>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sliders.delete')): ?>
                                            <button type="button" data-slider="<?php echo e($slider->id); ?>" class="btn btn-danger mr-1 waves-effect waves-light btn-delete"  data-toggle="modal" data-target="#delete-modal">حذف</button>
                                        <?php endif; ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>

<?php else: ?>
    <section class="card">
        <div class="card-header">
            <h4 class="card-title"><?php echo e($title); ?></h4>
        </div>
        <div class="card-content">
            <div class="card-body">
                <div class="card-text">
                    <p>چیزی برای نمایش وجود ندارد!</p>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>
<?php /**PATH /home/akoonli1/public_html/resources/views/back/partials/sliders.blade.php ENDPATH**/ ?>