<div class="product-card mb-2 mx-res-0">
    <?php if($product->isSpecial()): ?>
        <div class="promotion-badge text-right">
            <?php echo e(trans('front::messages.categories.special-sale')); ?>

        </div>
    <?php endif; ?>
    <div class="product-head">
        <?php if($product->labels->count()): ?>
            <div class="row">
                <div class="btn-group" role="group">
                    <?php $__currentLoopData = $product->labels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="fild_products">
                            <span><?php echo e($label->title); ?></span>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endif; ?>


        <?php if($product->discount): ?>
            <div class="discount">
                <span><?php echo e($product->discount); ?>%</span>
            </div>
        <?php endif; ?>
    </div>
    <a class="product-thumb" href="<?php echo e(route('front.products.show', ['product' => $product])); ?>"
       style="padding: 0 !important;">
        <img data-src="<?php echo e($product->image ? asset($product->image) : asset('/no-image-product.png')); ?>"
             src="<?php echo e(theme_asset('images/600-600.png')); ?>" alt="<?php echo e($product->title); ?>"
             style="width: 100%;
             height: 100%;
             object-fit: cover;">

    </a>
    <div class="product-card-body">

        <h5 class="product-title special-title" style="border-bottom: 1px solid #989898;">
            <a href="<?php echo e(route('front.products.show', ['product' => $product])); ?>"><?php echo e($product->title); ?></a>
        </h5>

        <?php if($product->category): ?>
            <a class="product-meta"
               href="<?php echo e(route('front.products.category', ['category' => $product->category])); ?>"><?php echo e($product->category->title); ?></a>
        <?php endif; ?>
        <div class="rating-stars">
            <?php for($product->rating; $product->rating > 0; $product->rating--): ?>
                <i class="mdi mdi-star active"></i>
            <?php endfor; ?>
        </div>

        <div class="product-prices-div">
            <span class="product-price text-left"><?php echo e($product->getLowestPrice()); ?></span>

            <?php if($product->getLowestDiscount()): ?>
                <del class="product-price text-danger text-left"><?php echo e($product->getLowestDiscount()); ?></del>
            <?php endif; ?>
        </div>

        <?php if($product->isSinglePrice()): ?>
            <div class="cart">
                <a data-action="<?php echo e(route('front.cart.store', ['product' => $product])); ?>"
                   class="d-flex align-items-center add-to-cart-single" href="javascript:void(0)"><i
                        class="mdi mdi-plus px-2"></i>
                    <span><?php echo e(trans('front::messages.categories.add-to-cart')); ?></span>
                </a>
            </div>
        <?php endif; ?>

    </div>
</div>
<?php /**PATH /home/akoonli1/public_html/themes/DefaultTheme/src/resources/views/products/partials/product-card.blade.php ENDPATH**/ ?>