<?php $__env->startPush('meta'); ?>
<?php if(option('allow_indexing_main_page') == "off"): ?>
    <meta name="robots" content="noindex, nofollow">
    <meta name="googlebot" content="noindex, nofollow">
    <meta name="bingbot" content="noindex, nofollow">

<?php else: ?>
    <meta name="robots" content="index, follow"/>
    <meta name="googlebot" content="index, follow">
    <meta name="bingbot" content="index, follow">
<?php endif; ?>
    <meta name="description" content="<?php echo e(option('info_short_description')); ?>">
    <meta name="keywords" content="<?php echo e(option('info_tags')); ?>">

    <link rel="canonical" href="<?php echo e(url('/')); ?>" />

    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "WebSite",
            "url": "<?php echo e(route('front.index')); ?>",
            "name": "<?php echo e(option('site_title')); ?>",
            "logo": "<?php echo e(option('info_logo') ? asset(option('info_logo')) : asset(config('front.asset_path') . 'img/logo.png')); ?>",
            "potentialAction": {
                "@type": "SearchAction",
                "target": "<?php echo e(route('front.products.search')); ?>/?q={search_term_string}",
                "query-input": "required name=search_term_string"
            }
        }
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Start main-content -->
    <main class="main-content dt-sl mt-4 mb-3">

        <div class="container main-container">
 <!-- #region -->
            <?php $__currentLoopData = $widgets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $widget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php switch($widget->key):
                    case ('fullscreen-slider'): ?>
                        <?php echo $__env->make('front::widgets.fullscreen-slider', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php break; ?>

                    <?php case ('main-slider'): ?>
                        <?php echo $__env->make('front::widgets.main-slider', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php break; ?>

                    <?php case ('products-default-block'): ?>
                        <?php echo $__env->make('front::widgets.products-default-block', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php break; ?>

                    <?php case ('products-colorful-block'): ?>
                        <?php echo $__env->make('front::widgets.products-colorful-block', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php break; ?>

                    <?php case ('middle-banners'): ?>
                        <?php echo $__env->make('front::widgets.middle-banners', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php break; ?>

                    <?php case ('coworker-sliders'): ?>
                        <?php echo $__env->make('front::widgets.coworker-sliders', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php break; ?>

                    <?php case ('sevices-sliders'): ?>
                        <?php echo $__env->make('front::widgets.sevices-sliders', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php break; ?>

                    <?php case ('categories'): ?>
                        <?php echo $__env->make('front::widgets.categories', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php break; ?>

                    <?php case ('posts'): ?>
                        <?php echo $__env->make('front::widgets.posts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php break; ?>

                    <?php case ('products-discount-block'): ?>
                        <?php echo $__env->make('front::widgets.discount-products', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php break; ?>

                    <?php case ('custom-page'): ?>
                        <?php echo $__env->make('front::widgets.custom-page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php break; ?>
                <?php endswitch; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>

    </main>
    <!-- End main-content -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function showIndexModal(name) {
            let now = new Date().getTime();
            let prevShowDate = localStorage.getItem(name);

            if (!prevShowDate || (Math.abs(now - prevShowDate) / 3600000) >= 24) {
                setTimeout(() => {
                    $(name).modal('show');
                    localStorage.setItem(name, new Date().getTime());
                }, 5000);
            }
        }
    </script>

    <?php if(option('dt_index_popup_type') == 'image'): ?>
        <div id="image-popup-modal" class="modal fade" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <a href="<?php echo e(option('dt_index_popup_link')); ?>">
                            <div class="d-none d-md-block">
                                <img src="<?php echo e(asset(option('dt_index_popup_image'))); ?>" class="img-responsive w-100">
                            </div>
                            <div class="d-block d-md-none">
                                <img src="<?php echo e(asset(option('dt_index_popup_image_mobile'))); ?>" class="img-responsive w-100">
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <script>
            showIndexModal('#image-popup-modal');
        </script>
    <?php elseif(option('dt_index_popup_type') == 'text'): ?>
        <div id="text-popup-modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body pt-0">
                        <p><?php echo option('dt_index_popup_text'); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <script>
            showIndexModal('#text-popup-modal');
        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('front::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/akoonli1/public_html/themes/DefaultTheme/src/resources/views/index.blade.php ENDPATH**/ ?>