<div class="main-menu menu-fixed menu-accordion menu-shadow <?php echo e(user_option('theme_color') == 'light' ? 'menu-light' : 'menu-dark'); ?>" data-scroll-to-active="true">
    <div class="navbar-header">
        <ul class="nav navbar-nav flex-row">
            <li class="nav-item mr-auto">
                <a class="navbar-brand" href="<?php echo e(Route::has('front.index') ? route('front.index') : url('/')); ?>" target="_blank">
                    <h2 class="brand-text mb-0"><?php echo e(option('info_site_title', 'لاراول شاپ')); ?></h2>
                </a></li>
        </ul>
    </div>
    <div class="shadow-bottom"></div>
    <div class="main-menu-content">
        <ul class="navigation navigation-main" id="main-menu-navigation" data-menu="menu-navigation">

            <li class="<?php echo e(active_class('admin.dashboard')); ?> nav-item"><a href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="feather icon-home"></i>
                    <span class="menu-title">داشبورد</span>
                </a>
            </li>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users')): ?>
                <li class="nav-item has-sub <?php echo e(open_class(['admin.users.*'])); ?>"><a href="#"><i class="feather icon-users"></i><span class="menu-title" > کاربران</span></a>
                    <ul class="menu-content">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.index')): ?>
                            <li class="<?php echo e(active_class('admin.users.index')); ?>">
                                <a href="<?php echo e(route('admin.users.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست کاربران</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.create')): ?>
                            <li class="<?php echo e(active_class('admin.users.create')); ?>">
                                <a href="<?php echo e(route('admin.users.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item">ایجاد کاربر</span></a>
                            </li>
                        <?php endif; ?>

                    </ul>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('posts')): ?>
                <li class="nav-item has-sub <?php echo e(open_class(['admin.posts.*'])); ?>"><a href="#"><i class="feather icon-file-text"></i><span class="menu-title" > وبلاگ</span></a>
                    <ul class="menu-content">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('posts.index')): ?>
                            <li class="<?php echo e(active_class('admin.posts.index')); ?>">
                                <a href="<?php echo e(route('admin.posts.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست نوشته ها</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('posts.create')): ?>
                            <li class="<?php echo e(active_class('admin.posts.create')); ?>">
                                <a href="<?php echo e(route('admin.posts.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item">ایجاد نوشته</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('posts.category')): ?>
                            <li class="<?php echo e(active_class('admin.posts.categories.index')); ?>">
                                <a href="<?php echo e(route('admin.posts.categories.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">دسته بندی ها</span></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products')): ?>
                <li class="nav-item has-sub <?php echo e(open_class(['admin.products.*', 'admin.brands.*', 'admin.sizetypes.*'])); ?>"><a href="#"><i class="feather icon-shopping-cart"></i><span class="menu-title" > محصولات</span></a>
                    <ul class="menu-content">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.index')): ?>
                            <li class="<?php echo e(active_class('admin.products.index')); ?>">
                                <a href="<?php echo e(route('admin.products.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست محصولات</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.create')): ?>
                            <li class="<?php echo e(active_class('admin.products.create')); ?>">
                                <a href="<?php echo e(route('admin.products.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item">ایجاد محصول</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.category')): ?>
                            <li class="<?php echo e(active_class('admin.products.categories.index')); ?>">
                                <a href="<?php echo e(route('admin.products.categories.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">دسته بندی ها</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.sizetypes')): ?>
                            <li class="<?php echo e(active_class('admin.sizetypes.index')); ?>">
                                <a href="<?php echo e(route('admin.sizetypes.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">راهنمای سایز</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.spectypes')): ?>
                            <li class="<?php echo e(active_class('admin.spectypes.index')); ?>">
                                <a href="<?php echo e(route('admin.spectypes.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">نوع مشخصات</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.stock-notify')): ?>
                            <li class="<?php echo e(active_class('admin.stock-notifies.index')); ?>">
                                <a href="<?php echo e(route('admin.stock-notifies.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست اطلاع از موجودی</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.prices')): ?>
                            <li class="<?php echo e(active_class('admin.product.prices.index')); ?>">
                                <a href="<?php echo e(route('admin.product.prices.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">قیمت ها</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.prices')): ?>
                            <li class="<?php echo e(active_class('admin.prices.index')); ?>">
                                <a href="<?php echo e(route('admin.prices.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">تغییر قیمت گروهی</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.prices')): ?>
                            <li class="<?php echo e(active_class('admin.product.torobPrices')); ?>">
                                <a href="<?php echo e(route('admin.product.torobPrices')); ?>"><i class="feather icon-circle"></i><span class="menu-item">مقایسه قیمت ترب</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products.brands')): ?>
                            <li class="<?php echo e(open_class(['admin.brands.*'])); ?>">
                                <a href="#"><i class="feather icon-circle"></i><span class="menu-item"> برندها</span></a>
                                <ul class="menu-content">
                                    <li class="<?php echo e(active_class('admin.brands.index')); ?>">
                                        <a class="<?php echo e(active_class('admin.brands.index')); ?>" href="<?php echo e(route('admin.brands.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست برندها</span></a>
                                    </li>
                                    <li class="<?php echo e(active_class('admin.brands.create')); ?>">
                                        <a class="<?php echo e(active_class('admin.brands.create')); ?>" href="<?php echo e(route('admin.brands.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item">ایجاد برند</span></a>
                                    </li>
                                </ul>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('attributes')): ?>
                            <li class="<?php echo e(open_class(['admin.attributeGroups.*'])); ?>">
                                <a href="#"><i class="feather icon-circle"></i><span class="menu-item"> ویژگی ها</span></a>
                                <ul class="menu-content">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('attributes.groups.index')): ?>
                                        <li class="<?php echo e(active_class('admin.attributeGroups.index')); ?>">
                                            <a class="<?php echo e(active_class('admin.attributeGroups.index')); ?>" href="<?php echo e(route('admin.attributeGroups.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست گروه ویژگی ها</span></a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('attributes.groups.create')): ?>
                                        <li class="<?php echo e(active_class('admin.attributeGroups.create')); ?>">
                                            <a class="<?php echo e(active_class('admin.attributeGroups.create')); ?>" href="<?php echo e(route('admin.attributeGroups.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item">ایجاد گروه ویژگی</span></a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('attributes.create')): ?>
                                        <li class="<?php echo e(active_class('admin.attributes.create')); ?>">
                                            <a class="<?php echo e(active_class('admin.attributes.create')); ?>" href="<?php echo e(route('admin.attributes.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item">ایجاد ویژگی</span></a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('filters')): ?>
                            <li class="<?php echo e(open_class(['admin.filters.*'])); ?>">
                                <a href="#"><i class="feather icon-circle"></i><span class="menu-item"> فیلترها</span></a>
                                <ul class="menu-content">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('filters.index')): ?>
                                        <li class="<?php echo e(active_class('admin.filters.index')); ?>">
                                            <a class="<?php echo e(active_class('admin.filters.index')); ?>" href="<?php echo e(route('admin.filters.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست فیلتر ها</span></a>
                                        </li>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('filters.create')): ?>
                                        <li class="<?php echo e(active_class('admin.filters.create')); ?>">
                                            <a class="<?php echo e(active_class('admin.filters.create')); ?>" href="<?php echo e(route('admin.filters.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item">ایجاد فیلتر</span></a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </li>
                        <?php endif; ?>

                    </ul>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('discounts')): ?>
                <li class="nav-item has-sub <?php echo e(open_class(['admin.discounts.*'])); ?>"><a href="#"><i class="feather icon-tag"></i><span class="menu-title"> تخفیف ها</span></a>
                    <ul class="menu-content">
                        <li class="<?php echo e(active_class('admin.discounts.index')); ?>">
                            <a class="<?php echo e(active_class('admin.discounts.index')); ?>" href="<?php echo e(route('admin.discounts.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست تخفیف ها</span></a>
                        </li>

                        <li class="<?php echo e(active_class('admin.discounts.create')); ?>">
                            <a class="<?php echo e(active_class('admin.discounts.create')); ?>" href="<?php echo e(route('admin.discounts.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item">ایجاد تخفیف</span></a>
                        </li>
                    </ul>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders')): ?>
                <li class="nav-item has-sub <?php echo e(open_class(['admin.orders.*'])); ?>"><a href="#"><i class="feather icon-briefcase"></i><span class="menu-title" > سفارشات</span></a>
                    <ul class="menu-content">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders.index')): ?>
                            <li class="<?php echo e(active_class('admin.orders.index')); ?>">
                                <a href="<?php echo e(route('admin.orders.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">همه سفارشات</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders.index')): ?>
                            <li class="">
                                <a href="<?php echo e(route('admin.orders.index')); ?>?status=paid&shipping_status=pending&type=online"><i class="feather icon-circle"></i><span class="menu-item">سفارشات جدید</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders.index')): ?>
                            <li class="">
                                <a href="<?php echo e(route('admin.orders.index')); ?>?status=paid"><i class="feather icon-circle"></i><span class="menu-item">سفارشات پرداخت شده</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders.index')): ?>
                            <li class="">
                                <a href="<?php echo e(route('admin.orders.index')); ?>?status=paid&shipping_status=reserved"><i class="feather icon-circle"></i><span class="menu-item">سفارشات رزرو شده</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders.index')): ?>
                            <li class="<?php echo e(active_class('admin.orders.notCompleted')); ?>">
                                <a href="<?php echo e(route('admin.orders.notCompleted')); ?>"><i class="feather icon-circle"></i><span class="menu-item"> محصولات منتظر ارسال</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders.create')): ?>
                            <li class="<?php echo e(active_class('admin.orders.create')); ?>">
                                <a href="<?php echo e(route('admin.orders.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item"> افزودن سفارش</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders.create')): ?>
                            <li class="<?php echo e(active_class('admin.orders.inPersonCreate')); ?>">
                                <a href="<?php echo e(route('admin.orders.inPersonCreate')); ?>"><i class="feather icon-circle"></i><span class="menu-item"> افزودن سفارش حضوری</span></a>
                            </li>
                        <?php endif; ?>

                    </ul>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('carriers')): ?>
                <li class="nav-item has-sub <?php echo e(open_class(['admin.provinces.*', 'admin.carriers.*', 'admin.tariffs.*'])); ?>"><a href="#"><i class="feather icon-package"></i><span class="menu-title"> حمل و نقل</span></a>
                    <ul class="menu-content">
                        <li class="<?php echo e(active_class('admin.carriers.index')); ?>">
                            <a class="<?php echo e(active_class('admin.carriers.index')); ?>" href="<?php echo e(route('admin.carriers.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">روش های ارسال</span></a>
                        </li>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('carriers.provinces.index')): ?>
                            <li class="<?php echo e(active_class('admin.provinces.index')); ?>">
                                <a class="<?php echo e(active_class('admin.provinces.index')); ?>" href="<?php echo e(route('admin.provinces.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست استان ها</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('carriers.provinces.create')): ?>
                            <li class="<?php echo e(active_class('admin.provinces.create')); ?>">
                                <a class="<?php echo e(active_class('admin.provinces.create')); ?>" href="<?php echo e(route('admin.provinces.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item">ایجاد استان</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('carriers.cities.create')): ?>
                            <li class="<?php echo e(active_class('admin.cities.create')); ?>">
                                <a class="<?php echo e(active_class('admin.cities.create')); ?>" href="<?php echo e(route('admin.cities.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item">ایجاد شهر</span></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sliders')): ?>
                <li class="nav-item has-sub <?php echo e(open_class(['admin.sliders.*'])); ?>"><a href="#"><i class="feather icon-sliders"></i><span class="menu-title" > اسلایدرها</span></a>
                    <ul class="menu-content">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sliders.index')): ?>
                            <li class="<?php echo e(active_class('admin.sliders.index')); ?>">
                                <a href="<?php echo e(route('admin.sliders.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست اسلایدرها</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sliders.create')): ?>
                            <li class="<?php echo e(active_class('admin.sliders.create')); ?>">
                                <a href="<?php echo e(route('admin.sliders.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item">ایجاد اسلایدر</span></a>
                            </li>
                        <?php endif; ?>

                    </ul>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('banners')): ?>
                <li class="nav-item has-sub <?php echo e(open_class(['admin.banners.*'])); ?>"><a href="#"><i class="feather icon-image"></i><span class="menu-title" > بنرها</span></a>
                    <ul class="menu-content">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('banners.index')): ?>
                            <li class="<?php echo e(active_class('admin.banners.index')); ?>">
                                <a href="<?php echo e(route('admin.banners.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست بنرها</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('banners.create')): ?>
                            <li class="<?php echo e(active_class('admin.banners.create')); ?>">
                                <a href="<?php echo e(route('admin.banners.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item">ایجاد بنر</span></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('links')): ?>
                <li class="nav-item has-sub <?php echo e(open_class(['admin.links.*'])); ?>"><a href="#"><i class="feather icon-link"></i><span class="menu-title" > لینک های فوتر</span></a>
                    <ul class="menu-content">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('links.index')): ?>
                            <li class="<?php echo e(active_class('admin.links.index')); ?>">
                                <a href="<?php echo e(route('admin.links.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست لینک ها</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('links.create')): ?>
                            <li class="<?php echo e(active_class('admin.links.create')); ?>">
                                <a href="<?php echo e(route('admin.links.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item">ایجاد لینک </span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('links.groups')): ?>
                            <li class="<?php echo e(active_class('admin.links.groups.index')); ?>">
                                <a href="<?php echo e(route('admin.links.groups.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست گروه ها </span></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pages')): ?>
                <li class="nav-item has-sub <?php echo e(open_class(['admin.pages.*'])); ?>"><a href="#"><i class="feather icon-file"></i><span class="menu-title" > صفحات</span></a>
                    <ul class="menu-content">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pages.index')): ?>
                            <li class="<?php echo e(active_class('admin.pages.index')); ?>">
                                <a href="<?php echo e(route('admin.pages.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست صفحات</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pages.create')): ?>
                            <li class="<?php echo e(active_class('admin.pages.create')); ?>">
                                <a href="<?php echo e(route('admin.pages.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item">ایجاد صفحه</span></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles')): ?>
                <li class="nav-item has-sub <?php echo e(open_class(['admin.roles.*'])); ?>"><a href="#"><i class="feather icon-unlock"></i><span class="menu-title" > مقام ها</span></a>
                    <ul class="menu-content">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles.index')): ?>
                            <li class="<?php echo e(active_class('admin.roles.index')); ?>">
                                <a href="<?php echo e(route('admin.roles.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست مقام ها</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles.create')): ?>
                            <li class="<?php echo e(active_class('admin.roles.create')); ?>">
                                <a href="<?php echo e(route('admin.roles.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item">ایجاد مقام</span></a>
                            </li>
                        <?php endif; ?>

                    </ul>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('statistics')): ?>
                <li class="nav-item has-sub"><a href="#"><i class="feather icon-pie-chart"></i><span class="menu-title" >گزارشات</span></a>
                    <ul class="menu-content">

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('statistics.orders')): ?>
                            <li class="<?php echo e(active_class('admin.statistics.orders')); ?>">
                                <a href="<?php echo e(route('admin.statistics.orders')); ?>"><i class="feather icon-circle"></i><span class="menu-item">سفارشات</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('statistics.users')): ?>
                            <li class="<?php echo e(active_class('admin.statistics.users')); ?>">
                                <a href="<?php echo e(route('admin.statistics.users')); ?>"><i class="feather icon-circle"></i><span class="menu-item">کاربران</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('statistics.views')): ?>
                            <li class="<?php echo e(active_class('admin.statistics.views')); ?>">
                                <a href="<?php echo e(route('admin.statistics.views')); ?>"><i class="feather icon-circle"></i><span class="menu-item">آمار بازدیدها</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('statistics.orders')): ?>
                            <li class="<?php echo e(active_class('admin.statistics.bestSellingProducts')); ?>">
                                <a href="<?php echo e(route('admin.statistics.bestSellingProducts')); ?>"><i class="feather icon-circle"></i><span class="menu-item">محصولات پرفروش</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('statistics.orders')): ?>
                            <li class="<?php echo e(active_class('admin.statistics.cityReport')); ?>">
                                <a href="<?php echo e(route('admin.statistics.cityReport')); ?>"><i class="feather icon-circle"></i><span class="menu-item"> سفارشات شهرها</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('statistics.orders')): ?>
                            <li class="<?php echo e(active_class('admin.statistics.stockReport')); ?>">
                                <a href="<?php echo e(route('admin.statistics.stockReport')); ?>"><i class="feather icon-circle"></i><span class="menu-item">موجودی محصولات</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('statistics.orders')): ?>
                            <li class="<?php echo e(active_class('admin.statistics.userOrders')); ?>">
                                <a href="<?php echo e(route('admin.statistics.userOrders')); ?>"><i class="feather icon-circle"></i><span class="menu-item">سفارش کاربران</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('statistics.viewsList')): ?>
                            <li class="<?php echo e(active_class('admin.statistics.viewsList')); ?>">
                                <a href="<?php echo e(route('admin.statistics.viewsList')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست بازدیدها</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('statistics.viewers')): ?>
                            <li class="<?php echo e(active_class('admin.statistics.viewers')); ?>">
                                <a href="<?php echo e(route('admin.statistics.viewers')); ?>"><i class="feather icon-circle"></i><span class="menu-item"> بازدید کنندگان امروز</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('statistics.sms')): ?>
                            <li class="<?php echo e(active_class('admin.statistics.smsLog')); ?>">
                                <a href="<?php echo e(route('admin.statistics.smsLog')); ?>"><i class="feather icon-circle"></i><span class="menu-item"> لاگ پیامک های ارسالی</span></a>
                            </li>
                        <?php endif; ?>


                    </ul>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('themes')): ?>
                <li class="nav-item has-sub <?php echo e(open_class(['admin.themes.*', 'admin.widgets.*'])); ?>"><a href="#"><i class="feather icon-layout"></i><span class="menu-title" >قالب </span></a>
                    <ul class="menu-content">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('themes.index')): ?>
                            <li class="<?php echo e(active_class('admin.themes.index')); ?>">
                                <a href="<?php echo e(route('admin.themes.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست قالب ها</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('themes.create')): ?>
                            <li class="<?php echo e(active_class('admin.themes.create')); ?>">
                                <a href="<?php echo e(route('admin.themes.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item">افزودن قالب جدید</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('themes.settings')): ?>
                            <?php if(config('front.settings.fields')): ?>
                                <li class="<?php echo e(active_class('admin.themes.settings')); ?>">
                                    <a href="<?php echo e(route('admin.themes.settings')); ?>"><i class="feather icon-circle"></i><span class="menu-item">تنظیمات قالب</span></a>
                                </li>
                            <?php endif; ?>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('themes.settings')): ?>
                            <?php if(config('front.home-widgets')): ?>
                                <li class="<?php echo e(active_class('admin.widgets.index')); ?>">
                                    <a href="<?php echo e(route('admin.widgets.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">مدیریت صفحه اصلی</span></a>
                                </li>
                            <?php endif; ?>
                        <?php endif; ?>

                    </ul>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tickets')): ?>
                <li class="nav-item has-sub <?php echo e(open_class(['admin.tickets.*'])); ?>"><a href="#"><i class="feather icon-inbox"></i><span class="menu-title" > تیکت ها</span></a>
                    <ul class="menu-content">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tickets.index')): ?>
                            <li class="<?php echo e(active_class('admin.tickets.index')); ?>">
                                <a href="<?php echo e(route('admin.tickets.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لیست تیکت ها</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tickets.create')): ?>
                            <li class="<?php echo e(active_class('admin.tickets.create')); ?>">
                                <a href="<?php echo e(route('admin.tickets.create')); ?>"><i class="feather icon-circle"></i><span class="menu-item">ایجاد تیکت</span></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['payments'])): ?>
                <li class="nav-item has-sub <?php echo e(open_class(['admin.transactions.*', 'admin.currencies.*'])); ?>"><a href="#"><i class="feather icon-credit-card"></i><span class="menu-title" > پرداخت</span></a>
                    <ul class="menu-content">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payments.transactions.index')): ?>
                            <li class="<?php echo e(active_class('admin.transactions.index')); ?> nav-item">
                                <a href="<?php echo e(route('admin.transactions.index')); ?>">
                                    <i class="feather feather icon-circle"></i>
                                    <span class="menu-title"> لیست تراکنش ها</span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payments.wallet-histories.index')): ?>
                            <li class="<?php echo e(active_class('admin.wallet-histories.index')); ?> nav-item">
                                <a href="<?php echo e(route('admin.wallet-histories.index')); ?>">
                                    <i class="feather feather icon-circle"></i>
                                    <span class="menu-title"> تاریخچه کیف پول</span>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payments.currencies')): ?>
                            <li class="<?php echo e(active_class('admin.currencies.index')); ?> nav-item">
                                <a href="<?php echo e(route('admin.currencies.index')); ?>">
                                    <i class="feather feather icon-circle"></i>
                                    <span class="menu-title"> لیست ارز ها</span>
                                </a>
                            </li>
                        <?php endif; ?>

                    </ul>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['comments'])): ?>
                <li class="nav-item has-sub <?php echo e(open_class(['admin.comments.*'])); ?>"><a href="#"><i class="feather icon-message-circle"></i><span class="menu-title" > نظرات</span></a>
                    <ul class="menu-content">

                        <li class="<?php echo e(active_class('admin.comments.products')); ?> nav-item">
                            <a href="<?php echo e(route('admin.comments.products')); ?>">
                                <i class="feather feather icon-circle"></i>
                                <span class="menu-title"> پرسش و پاسخ محصولات</span>
                            </a>
                        </li>
                        <li class="<?php echo e(active_class('admin.reviews.index')); ?> nav-item">
                            <a href="<?php echo e(route('admin.reviews.index')); ?>">
                                <i class="feather feather icon-circle"></i>
                                <span class="menu-title"> نظرات محصولات</span>
                            </a>
                        </li>
                        <li class="<?php echo e(active_class('admin.comments.posts')); ?> nav-item">
                            <a href="<?php echo e(route('admin.comments.posts')); ?>">
                                <i class="feather feather icon-circle"></i>
                                <span class="menu-title"> نظرات وبلاگ</span>
                            </a>
                        </li>

                    </ul>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('menus')): ?>
                <li class="<?php echo e(active_class('admin.menus.index')); ?> nav-item">
                    <a href="<?php echo e(route('admin.menus.index')); ?>">
                        <i class="feather icon-menu"></i>
                        <span class="menu-title"> منوها</span>
                    </a>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contacts')): ?>
                <li class="<?php echo e(active_class('admin.contacts.index')); ?> nav-item">
                    <a href="<?php echo e(route('admin.contacts.index')); ?>">
                        <i class="feather icon-message-square"></i>
                        <span class="menu-title">لیست تماس با ما</span>
                    </a>
                </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings')): ?>
                <li class="nav-item has-sub">
                    <a href="#">
                        <i class="feather icon-settings"></i>
                        <span class="menu-title" >تنظیمات</span>
                    </a>
                    <ul class="menu-content">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings.information')): ?>
                            <li class="<?php echo e(active_class('admin.settings.information')); ?>">
                                <a href="<?php echo e(route('admin.settings.information')); ?>"><i class="feather icon-circle"></i><span class="menu-item">اطلاعات کلی</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings.socials')): ?>
                            <?php if(config('front.socials')): ?>
                                <li class="<?php echo e(active_class('admin.settings.socials')); ?>">
                                    <a href="<?php echo e(route('admin.settings.socials')); ?>"><i class="feather icon-circle"></i><span class="menu-item">شبکه های اجتماعی</span></a>
                                </li>
                            <?php endif; ?>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings.gateway')): ?>
                            <li class="<?php echo e(active_class('admin.settings.gateways')); ?>">
                                <a href="<?php echo e(route('admin.settings.gateways')); ?>"><i class="feather icon-circle"></i><span class="menu-item">درگاه های پرداخت</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings.others')): ?>
                            <li class="<?php echo e(active_class('admin.settings.others')); ?>">
                                <a href="<?php echo e(route('admin.settings.others')); ?>"><i class="feather icon-circle"></i><span class="menu-item">تنظیمات دیگر</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings.sms')): ?>
                            <li class="<?php echo e(active_class('admin.settings.sms')); ?>">
                                <a href="<?php echo e(route('admin.settings.sms')); ?>"><i class="feather icon-circle"></i><span class="menu-item">تنظیمات پیامک</span></a>
                            </li>
                        <?php endif; ?>

                    </ul>
                </li>
            <?php endif; ?>

            <li class="nav-item has-sub <?php echo e(open_class(['admin.file-manager', 'admin.backups.*', 'admin.apikeys.*', 'admin.notifications'])); ?>">
                <a href="#">
                    <i class="feather icon-more-horizontal"></i>
                    <span class="menu-title">دیگر</span>
                </a>
                <ul class="menu-content">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('file-manager')): ?>
                        <li class="<?php echo e(active_class('admin.file-manager')); ?> nav-item">
                            <a href="<?php echo e(route('admin.file-manager')); ?>">
                                <i class="feather icon-folder"></i>
                                <span class="menu-title"> فایل ها</span>
                            </a>
                        </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('backups.index')): ?>
                        <li class="<?php echo e(active_class('admin.backups.index')); ?> nav-item">
                            <a href="<?php echo e(route('admin.backups.index')); ?>">
                                <i class="feather icon-upload-cloud"></i>
                                <span class="menu-title">لیست بکاپ ها</span>
                            </a>
                        </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('apikeys.index')): ?>
                        <li class="<?php echo e(active_class('admin.apikeys.index')); ?> nav-item">
                            <a href="<?php echo e(route('admin.apikeys.index')); ?>">
                                <i class="fa fa-key"></i>
                                <span class="menu-title">کلیدهای وب سرویس</span>
                            </a>
                        </li>
                    <?php endif; ?>

                    <li class="<?php echo e(active_class('admin.notifications')); ?> nav-item">
                        <a href="<?php echo e(route('admin.notifications')); ?>">
                            <i class="feather icon-bell"></i>
                            <div class="d-flex justify-content-between w-100">
                                <span class="menu-title"> اعلان ها</span>
                                <?php if($notifications->count()): ?>
                                    <span class="badge badge badge-primary badge-pill"> <?php echo e($notifications->count()); ?></span>
                                <?php endif; ?>
                            </div>
                        </a>
                    </li>

                </ul>
            </li>

            <?php if(auth()->user()->isCreator()): ?>
                <li class="nav-item has-sub">
                    <a href="#">
                        <i class="feather icon-alert-octagon"></i>
                        <span class="menu-title" >توسعه دهنده</span>
                        <span class="badge badge-danger badge-pill float-right mr-2">creator</span>
                    </a>
                    <ul class="menu-content">
                        <li class="<?php echo e(active_class('admin.permissions.index')); ?>">
                            <a href="<?php echo e(route('admin.permissions.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">دسترسی ها</span></a>
                        </li>

                        <li class="<?php echo e(active_class('admin.developer.settings')); ?>">
                            <a href="<?php echo e(route('admin.developer.settings')); ?>"><i class="feather icon-circle"></i><span class="menu-item">تنظیمات توسعه دهنده</span></a>
                        </li>

                        <li class="<?php echo e(active_class('admin.logs.index')); ?>">
                            <a target="_blank" href="<?php echo e(route('admin.logs.index')); ?>"><i class="feather icon-circle"></i><span class="menu-item">لاگ ها</span></a>
                        </li>

                        <li class="<?php echo e(active_class('admin.developer.showUpdater')); ?>">
                            <a href="<?php echo e(route('admin.developer.showUpdater')); ?>"><i class="feather icon-circle"></i><span class="menu-item">بروزرسانی</span></a>
                        </li>

                    </ul>
                </li>
            <?php endif; ?>

        </ul>
    </div>
</div>
<?php /**PATH /home/akoonli1/public_html/resources/views/back/partials/sidebar.blade.php ENDPATH**/ ?>