<div class="item">
    <div class="product-card mb-3">
        <div class="product-head">
            <?php if($product->labels->count()): ?>
                <div class="row">
                    <div class="btn-group" role="group">
                        <?php $__currentLoopData = $product->labels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="fild_products">
                                <span><?php echo e($label->title); ?></span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>
            <?php if($product->discount): ?>
                <div class="discount">
                    <span><?php echo e($product->discount); ?>%</span>
                </div>
            <?php endif; ?>
        </div>
        <a class="product-thumb" href="<?php echo e(route('front.products.show', ['product' => $product])); ?>">
            <img data-src="<?php echo e($product->image ? asset($product->image) : asset('/no-image-product.png')); ?>" src="<?php echo e(theme_asset('images/600-600.png')); ?>" alt="<?php echo e($product->title); ?>">
        </a>
        <div class="product-card-body">
            <h5 class="product-title">
                <a href="<?php echo e(route('front.products.show', ['product' => $product])); ?>" title="<?php echo e($product->title); ?>"><?php echo e($product->title); ?></a>
            </h5>
            <div class="rating-stars">
                <a class="product-meta" href="<?php echo e($product->category ? $product->category->link : '#'); ?>"><?php echo e($product->category ? $product->category->title : trans('front::messages.partials.no-category')); ?></a>
                <?php if($product->rating): ?>
                    <span class="mx-3 float-left"><?php echo e($product->rating); ?><i class="mr-1 mdi mdi-star active"></i></span>
                <?php endif; ?>
            </div>
            <div class="price-index-h">
                <span class="product-price"><?php echo e($product->getLowestPrice()); ?></span>

                <?php if($product->getLowestDiscount()): ?>
                    <del class="product-price-del"><?php echo e($product->getLowestDiscount()); ?></del>
                <?php endif; ?>

            </div>
            <?php if($product->isSpecial() && $product->special_end_date && $product->special_end_date->diffInHours(now()) <= 24): ?>
                <div class="countdown-timer mt-4 text-muted product-special-end-date" countdown data-date="<?php echo e($product->special_end_date->format('D M d Y H:i:s O')); ?>">
                    <span data-seconds="">0</span> :
                    <span data-minutes="">0</span> :
                    <span data-hours="">0</span>
                    <i class="mdi mdi-clock"></i>
                </div>
            <?php endif; ?>
            <?php if($product->isSinglePrice()): ?>
                <div class="cart">
                    <a data-action="<?php echo e(route('front.cart.store', ['product' => $product])); ?>" class="d-flex align-items-center add-to-cart-single" href="javascript:void(0)"><i class="mdi mdi-plus px-2"></i>
                        <span><?php echo e(trans('front::messages.partials.add-to-cart')); ?></span>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH /home/akoonli1/public_html/themes/DefaultTheme/src/resources/views/partials/product-block-2.blade.php ENDPATH**/ ?>