<?php
    $cart = isset($render_cart) ? $render_cart : $cart;
?>

<?php if($cart && $cart->products()->count()): ?>
    <li class="nav-item" id="cart-list-item">
        <a class="nav-link" href="#" data-toggle="dropdown" aria-haspopup="true"
        aria-expanded="false">
            <span class="label-dropdown"><?php echo e(trans('front::messages.header.cart')); ?></span>
            <i class="mdi mdi-cart-outline"></i>
            <span class="count"><?php echo e($cart->quantity); ?></span>
        </a>
        <div class="dropdown-menu cart dropdown-menu-sm dropdown-menu-left">
            <div class="dropdown-header"><?php echo e(trans('front::messages.header.cart')); ?></div>
            <div class="dropdown-list-icons">

                <?php $__currentLoopData = $cart->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('front.products.show', ['product' => $product])); ?>" class="dropdown-item">
                        <div class="dropdown-item-icon">
                            <img src="<?php echo e($product->image ? $product->image : '/empty.jpg'); ?>" alt="<?php echo e($product->title); ?>">
                        </div>
                        <div class="mr-3 cart-title">
                            <?php echo e($product->title); ?>


                                <?php
                                    $cart_product_price = $product->prices()->find($product->pivot->price_id);
                                ?>

                                <div class="pt-1"><?php echo e(trans('front::messages.currency.prefix')); ?><?php echo e(number_format($cart_product_price->salePrice() * $product->pivot->quantity)); ?> <?php echo e(trans('front::messages.currency.suffix')); ?></div>
                                <?php if($cart_product_price->hasDiscount()): ?>
                                    <del class="text-danger"><?php echo e(trans('front::messages.currency.prefix')); ?><?php echo e(number_format($cart_product_price->regularPrice() * $product->pivot->quantity)); ?> <?php echo e(trans('front::messages.currency.suffix')); ?></del>
                                <?php endif; ?>

                        </div>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <hr>
            <div class="dropdown-footer text-center">
                <div class="dt-sl mb-3">
                    <span class="float-right"><?php echo e(trans('front::messages.header.total')); ?></span>
                    <span class="float-left"><?php echo e(trans('front::messages.currency.prefix')); ?><?php echo e(number_format($cart->discountPrice())); ?> <?php echo e(trans('front::messages.currency.suffix')); ?></span>
                </div>
                <a href="<?php echo e(route('front.cart')); ?>" class="btn btn-success"><?php echo e(trans('front::messages.header.view-cart')); ?></a>
                <a href="<?php echo e(route('front.checkout')); ?>" class="btn btn-primary"><?php echo e(trans('front::messages.header.payment')); ?></a>
            </div>
        </div>
    </li>

<?php else: ?>

    <li class="nav-item" id="cart-list-item">
        <a class="nav-link" href="#" data-toggle="dropdown" aria-haspopup="true"
        aria-expanded="false">
            <span class="label-dropdown"><?php echo e(trans('front::messages.header.cart')); ?></span>
            <i class="mdi mdi-cart-outline"></i>
        </a>
        <div class="dropdown-menu cart dropdown-menu-sm dropdown-menu-left text-center">
            <p class="pt-2"><?php echo e(trans('front::messages.header.shopping-cart-empty')); ?></p>
        </div>
    </li>

<?php endif; ?>
<?php /**PATH /home/akoonli1/public_html/themes/DefaultTheme/src/resources/views/partials/cart.blade.php ENDPATH**/ ?>